/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.invp.business.FieldSelectorHelper;
import kd.scmc.invp.common.helper.FilterConditionHelper;

public class InvpSchemeEditPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public static MainEntityType getMainEntityType(IDataModel model, int index, String fieldName) {
        Object entity = model.getValue(fieldName, index);
        if (entity == null) {
            IDataEntityProperty pro = model.getDataEntityType().findProperty(fieldName);
            String proName = pro.getDisplayName().getLocaleValue();
            throw new KDBizException(ResManager.loadKDString((String)"\u5148\u9009\u62e9{0}\u3002", (String)"InvpSchemeEditPlugin_5", (String)"scmc-invp-form", (Object[])new Object[]{proName}));
        }
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)((DynamicObject)entity).getString("id"));
        if (type == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5143\u6570\u636e{0}\u5b9e\u4f53\u4e0d\u5b58\u5728\u3002", (String)"InvpSchemeEditPlugin_6", (String)"scmc-invp-form", (Object[])new Object[]{fieldName}));
        }
        return type;
    }

    private void addBaseDataF7Listener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(key);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        this.initFilterGrid();
        this.setFilterValue();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEntryEnable();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof FormOperate) {
            String operateKey;
            switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
                case "save": 
                case "submit": {
                    this.storeInvLevelFilter();
                    break;
                }
                case "moveentryup": {
                    DynamicObject supEntity;
                    int selectRow = this.getSelectRow("supparamentry");
                    if (selectRow != 1 || !"im_inv_realbalance".equals((supEntity = (DynamicObject)this.getModel().getValue("supplydatasrc", 0)).get("id"))) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u79fb\u5931\u8d25\uff0c\u5373\u65f6\u5e93\u5b58\u4f59\u989d\u8868\u7684\u4f9b\u5e94\u4f18\u5148\u7ea7\u6700\u9ad8\u3002", (String)"InvpSchemeEditPlugin_13", (String)"scmc-invp-form", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                case "moveentrydown": {
                    DynamicObject supEntity;
                    int selectRow = this.getSelectRow("supparamentry");
                    if (selectRow != 0 || !"im_inv_realbalance".equals((supEntity = (DynamicObject)this.getModel().getValue("supplydatasrc", 0)).get("id"))) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u79fb\u5931\u8d25\uff0c\u5373\u65f6\u5e93\u5b58\u4f59\u989d\u8868\u7684\u4f9b\u5e94\u4f18\u5148\u7ea7\u6700\u9ad8\u3002", (String)"InvpSchemeEditPlugin_14", (String)"scmc-invp-form", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
            }
        }
    }

    private int getSelectRow(String entryKey) {
        EntryGrid supplyGrid = (EntryGrid)this.getControl(entryKey);
        int[] selectRows = supplyGrid.getSelectRows();
        int selectRow = -1;
        if (selectRows != null && selectRows.length > 0) {
            selectRow = selectRows[0];
        }
        return selectRow;
    }

    private void storeInvLevelFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        String filterJson = SerializationUtils.toJsonString((Object)filterCondition);
        this.getModel().setValue("invlevelfilter_tag", (Object)filterJson);
    }

    private void initFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.setEntityNumber("invp_invlevel");
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
        if (dimension != null) {
            DynamicObjectCollection entries = dimension.getDynamicObjectCollection("entryentity");
            Set fields = entries.stream().map(entry -> entry.getDynamicObject("associationobject").getString("number")).collect(Collectors.toSet());
            fields.remove("bos_org");
            MainEntityType billEntity = MetadataServiceHelper.getDataEntityType((String)"invp_invlevel");
            List filterColumns = EntityTypeUtil.getInstance().getFilterColumns((IDataEntityType)billEntity);
            filterColumns = filterColumns.stream().filter(columInfo -> {
                String fieldName = (String)columInfo.get("fieldName");
                if (fieldName.indexOf(".") > -1) {
                    fieldName = fieldName.substring(0, fieldName.indexOf("."));
                }
                return fields.contains(fieldName);
            }).collect(Collectors.toList());
            filterGrid.setFilterColumns(filterColumns);
        }
        this.getView().updateView("filtergridap");
    }

    private void setFilterValue() {
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        String invLevelFilter = (String)this.getModel().getValue("invlevelfilter_tag");
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)invLevelFilter)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)invLevelFilter, FilterCondition.class);
            filterGrid.SetValue(filterCondition);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        EntryGrid dataSrcEntity = (EntryGrid)this.getView().getControl("demprientry");
        this.batchCreateEntryRows(dataSrcEntity, "demprientry", 1);
        this.getModel().setValue("demandentity", (Object)"invp_demand_model", 0);
        this.getModel().setValue("demcolsign", (Object)"demanddate", 0);
        this.getModel().setValue("demcolname", (Object)ResManager.loadKDString((String)"\u9700\u6c42\u65e5\u671f", (String)"InvpSchemeEditPlugin_8", (String)"scmc-invp-form", (Object[])new Object[0]), 0);
        this.setMatchDimension();
        this.setAlgoScheme();
    }

    private void setAlgoScheme() {
        DynamicObjectCollection algoConfigs;
        QFilter baseDataFilter;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        DynamicObject planOrg = (DynamicObject)this.getModel().getValue("createorg");
        if (planOrg != null && (baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"invp_algoconfig", (Long)planOrg.getLong("id"))) != null) {
            filters.add(baseDataFilter);
        }
        if ((algoConfigs = QueryServiceHelper.query((String)"invp_algoconfig", (String)"id", (QFilter[])filters.toArray(new QFilter[0]))).size() == 1) {
            this.getModel().setValue("algorithmplan", ((DynamicObject)algoConfigs.get(0)).get("id"));
        }
    }

    public static void showConvertRuleEdit(final IFormView view, String botpKey) {
        BasedataEdit botpIdEdit = (BasedataEdit)view.getControl(botpKey);
        if (botpIdEdit == null) {
            return;
        }
        botpIdEdit.addBeforeF7ViewDetailListener((Consumer)new Consumer<BeforeF7ViewDetailEvent>(){

            @Override
            public void accept(BeforeF7ViewDetailEvent t) {
                t.setCancel(true);
                Object pkId = t.getPkId();
                DynamicObject botpObj = BusinessDataServiceHelper.loadSingleFromCache((Object)pkId, (String)"botp_crlist");
                String srcEntity = botpObj.getString("sourceentitynumber.number");
                String tgtEntity = botpObj.getString("targetentitynumber.number");
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("botp_convertrule");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setCustomParam("SourceBill", (Object)srcEntity);
                showParameter.setCustomParam("TargetBill", (Object)tgtEntity);
                showParameter.setCustomParam("ruleId", pkId);
                showParameter.getCustomParams().put("checkRightAppId", "bpm");
                showParameter.setPageId(pkId + "_" + srcEntity + "_" + tgtEntity);
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.setAppId("invp");
                showParameter.addCustPlugin("kd.scmc.invp.formplugin.InvpConvertRuleLockEditPlugin");
                view.showForm(showParameter);
            }
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addBaseDataF7Listener("algorithmplan", "entrydemandorg", "entrysupplypolicy", "demandmodel", "supplymodel", "suptodemmapping", "demtolevelmapping", "autoputbotp", "planner", "plangroup");
        this.addClickListeners(new String[]{"demcolname", "unioncolname", "filtercondition"});
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.addBeforeF7SelectListener(this::beforeFilterGridF7Select);
        InvpSchemeEditPlugin.showConvertRuleEdit(this.getView(), "autoputbotp");
    }

    public void beforeFilterGridF7Select(BeforeFilterF7SelectEvent evt) {
        String fieldName = evt.getFieldName();
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1").and("status", "=", (Object)"C");
        MulBasedataDynamicObjectCollection orgs = (MulBasedataDynamicObjectCollection)this.getModel().getValue("bosorg");
        List orgIds = null;
        if (orgs != null && !orgs.isEmpty()) {
            orgIds = orgs.stream().map(org -> org.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        }
        if (fieldName.contains(".")) {
            fieldName = fieldName.substring(0, fieldName.indexOf("."));
        }
        switch (fieldName) {
            case "bd_material": {
                evt.getCustomQFilters().add(statusFilter);
                if (orgs == null || orgs.isEmpty() || orgs == null || orgs.isEmpty()) break;
                QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", orgIds, (boolean)true);
                evt.getCustomQFilters().add(orgFilter);
                break;
            }
            case "bd_warehouse": {
                evt.getCustomQFilters().add(statusFilter);
                if (orgs == null || orgs.isEmpty() || orgs == null || orgs.isEmpty()) break;
                QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_warehouse", orgIds, (boolean)true);
                evt.getCustomQFilters().add(orgFilter);
                break;
            }
            case "bd_materialgroupstandard": {
                QFilter stateFilter = new QFilter("enable", "=", (Object)"1");
                evt.getCustomQFilters().add(stateFilter);
                break;
            }
            case "bd_materialgroup": {
                FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "demcolname": {
                this.clickSrcCol("demprientry", "demcolname", "demcolsign", "demandentity");
                break;
            }
            case "unioncolname": {
                this.clickSrcCol("outputresentry", "unioncolname", "uniocolsign", "unionsrcentity");
                break;
            }
            case "filtercondition": {
                this.openConditionSet();
                break;
            }
        }
    }

    private void openConditionSet() {
        int row = this.getModel().getEntryCurrentRowIndex("outputparamentry");
        DynamicObject demModel = (DynamicObject)this.getModel().getValue("demandmodel");
        if (demModel == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u9700\u6c42\u6a21\u578b\u3002", (String)"InvpSchemeEditPlugin_7", (String)"scmc-invp-form", (Object[])new Object[0]));
            return;
        }
        DynamicObject outputType = demModel.getDynamicObject("outputtype");
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("invp_conditionsetup");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "invp_conditionsetup"));
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        Object filterDs = this.getModel().getValue("filtervalue", row);
        String number = outputType.getString("number");
        params.put("number", number);
        params.put("filter", filterDs);
        params.put("row", row);
        fsp.setCustomParams(params);
        this.getView().showForm(fsp);
    }

    private void clickSrcCol(String entryKey, String colName, String colSign, String entityKey) {
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex(entryKey);
        MainEntityType srcEntityType = InvpSchemeEditPlugin.getMainEntityType(model, index, entityKey);
        PropTreeBuildOption ops = new PropTreeBuildOption();
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)srcEntityType, (PropTreeBuildOption)ops);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryKey);
        HashSet<String> configed = new HashSet<String>(16);
        for (DynamicObject entry : entryEntity) {
            String key = entry.getString(colSign);
            if (key == null || key.isEmpty()) continue;
            configed.add(entry.getString(colSign));
        }
        FieldSelectorHelper.removeTreeNode(srcBillNode, configed);
        FormShowParameter showParameter = FieldSelectorHelper.showSelectFieldForm(srcBillNode);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, colName));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId = e.getActionId()) {
            case "demcolname": {
                this.callBackDemCol("demprientry", "demcolname", "demcolsign", "demandentity", (String)returnData);
                break;
            }
            case "unioncolname": {
                this.callBackDemCol("outputresentry", "unioncolname", "uniocolsign", "unionsrcentity", (String)returnData);
                break;
            }
            case "invp_conditionsetup": {
                this.callConditionSetup(returnData);
                break;
            }
        }
    }

    private void callConditionSetup(Object returnData) {
        Map data = (Map)returnData;
        if (data != null) {
            String filter = (String)data.get("filter");
            String number = (String)data.get("number");
            int row = (Integer)data.get("row");
            String filterDesc = FilterConditionHelper.translateJsonString(filter, number);
            this.getModel().setValue("filtervalue", (Object)filter, row);
            this.getModel().setValue("filtercondition", (Object)filterDesc, row);
        }
    }

    private void callBackDemCol(String entryKey, String colName, String colSign, String entityKey, String returnCol) {
        int row;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)returnCol)) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject entity = (DynamicObject)model.getValue(entityKey, row = model.getEntryCurrentRowIndex(entryKey));
        String source = entity.getString("id");
        if (returnCol.equals(source) || returnCol.equals("billhead")) {
            return;
        }
        MainEntityType sourceType = EntityMetadataCache.getDataEntityType((String)source);
        model.setValue(colSign, (Object)FieldSelectorHelper.getFullCol(sourceType, returnCol), row);
        model.setValue(colName, (Object)FieldSelectorHelper.getColName(sourceType, returnCol), row);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String name;
        super.afterAddRow(e);
        switch (name = e.getEntryProp().getName()) {
            case "demprientry": {
                this.addDemandModelRefRow(e, "demandentity", "invp_demand_model");
                break;
            }
            case "outputresentry": {
                this.addDemandModelRefRow(e, "unionsrcentity", "invp_plan_advice");
                break;
            }
        }
    }

    private void addDemandModelRefRow(AfterAddRowEventArgs e, String entity, String entityType) {
        RowDataEntity[] rows;
        for (RowDataEntity row : rows = e.getRowDataEntities()) {
            this.getModel().setValue(entity, (Object)entityType, row.getRowIndex());
        }
    }

    private void setEntryEnable() {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        int rowIndex = changeSet[0].getRowIndex();
        switch (propName) {
            case "entrydemandorg": {
                this.changeDemandOrg(rowIndex);
                break;
            }
            case "supplymodel": {
                this.changeDemandModel(newValue, "supparamentry", "supplydatasrc", propName);
                break;
            }
            case "demandmodel": {
                this.changeDemandModel(newValue, "demandparamentry", "demandsrc", propName);
                break;
            }
            case "demcolname": {
                this.changedEntryColName(rowIndex, "demcolname", "demcolsign");
                break;
            }
            case "unioncolname": {
                this.changedEntryColName(rowIndex, "unioncolname", "uniocolsign");
                break;
            }
            case "filtercondition": {
                this.changedEntryColName(rowIndex, "filtercondition", "filtervalue");
                break;
            }
            case "targetputbill": {
                this.changeTarPutBill(rowIndex);
                break;
            }
            case "dimension": {
                this.changedDimension(oldValue);
                break;
            }
            case "bosorg": {
                this.changedBosOrg(oldValue);
                break;
            }
            case "planner": {
                this.changedPlanner(oldValue);
                break;
            }
            case "plangroup": {
                this.changedPlanGroup(oldValue);
                break;
            }
        }
    }

    private void changedBosOrg(Object oldValue) {
        if (oldValue == null || ((MulBasedataDynamicObjectCollection)oldValue).isEmpty()) {
            this.setDemandParamEntryByBosOrg();
        } else {
            List orgIdList = ((MulBasedataDynamicObjectCollection)oldValue).stream().map(org -> org.getDynamicObject("fbasedataid").getString("id")).collect(Collectors.toList());
            String message = ResManager.loadKDString((String)"\u4fee\u6539\u4e1a\u52a1\u7ec4\u7ec7\uff0c\u5c06\u6e05\u7a7a\u7ec4\u7ec7\u4fe1\u606f\u5206\u5f55\uff0c\u662f\u5426\u786e\u8ba4\u4fee\u6539\uff1f", (String)"InvpSchemeEditPlugin_12", (String)"scmc-invp", (Object[])new Object[0]);
            this.getView().showConfirm(message, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("bosorg"), null, SerializationUtils.toJsonString(orgIdList));
        }
    }

    private void changedPlanner(Object oldValue) {
        Object planGroup = this.getModel().getValue("plangroup");
        if (planGroup != null && !((MulBasedataDynamicObjectCollection)planGroup).isEmpty()) {
            List orgIdList = ((MulBasedataDynamicObjectCollection)oldValue).stream().map(org -> org.getDynamicObject("fbasedataid").getString("id")).collect(Collectors.toList());
            String message = ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u4f9d\u636e\u8ba1\u5212\u5458\u786e\u8ba4\u8ba1\u5212\u8303\u56f4\u5417\uff1f\u6b64\u64cd\u4f5c\u5c06\u6e05\u7a7a\u8ba1\u5212\u7ec4\u7684\u4fe1\u606f\u3002", (String)"InvpSchemeEditPlugin_15", (String)"scmc-invp", (Object[])new Object[0]);
            this.getView().showConfirm(message, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("planner"), null, SerializationUtils.toJsonString(orgIdList));
        }
    }

    private void changedPlanGroup(Object oldValue) {
        Object planner = this.getModel().getValue("planner");
        if (planner != null && !((MulBasedataDynamicObjectCollection)planner).isEmpty()) {
            List orgIdList = ((MulBasedataDynamicObjectCollection)oldValue).stream().map(org -> org.getDynamicObject("fbasedataid").getString("id")).collect(Collectors.toList());
            String message = ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u4f9d\u636e\u8ba1\u5212\u7ec4\u786e\u8ba4\u8ba1\u5212\u8303\u56f4\u5417\uff1f\u6b64\u64cd\u4f5c\u5c06\u6e05\u7a7a\u8ba1\u5212\u5458\u7684\u4fe1\u606f\u3002", (String)"InvpSchemeEditPlugin_16", (String)"scmc-invp", (Object[])new Object[0]);
            this.getView().showConfirm(message, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("plangroup"), null, SerializationUtils.toJsonString(orgIdList));
        }
    }

    private void setDemandParamEntryByBosOrg() {
        MulBasedataDynamicObjectCollection orgs = (MulBasedataDynamicObjectCollection)this.getModel().getValue("bosorg");
        this.getModel().deleteEntryData("orgparamentry");
        for (DynamicObject org : orgs) {
            DynamicObject demandOrg = org.getDynamicObject("fbasedataid");
            int index = this.getModel().createNewEntryRow("orgparamentry");
            this.getModel().setValue("entrydemandorg", (Object)demandOrg, index);
        }
        this.getModel().setValue("planner", null);
        this.getModel().setValue("plangroup", null);
    }

    private void changedDimension(Object oldValue) {
        if (oldValue == null) {
            this.initFilterGrid();
            FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
            filterGrid.SetValue(new FilterCondition());
            this.getModel().setValue("invlevelfilter_tag", null);
            this.setMatchDimension();
        } else {
            String message = ResManager.loadKDString((String)"\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u5207\u6362\uff0c\u5c06\u6e05\u7a7a\u8ba1\u5212\u8303\u56f4\u8fc7\u6ee4\u6761\u4ef6\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"InvpSchemeEditPlugin_11", (String)"scmc-invp", (Object[])new Object[0]);
            this.getView().showConfirm(message, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("dimension"), null, ((DynamicObject)oldValue).getPkValue().toString());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        String customValue = messageBoxClosedEvent.getCustomVaule();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "dimension": {
                this.dimensionCallBack(result, customValue);
                break;
            }
            case "bosorg": {
                this.bosOrgCallBack(result, customValue);
                break;
            }
            case "planner": {
                this.plannerCallBack(result);
                break;
            }
            case "plangroup": {
                this.planGroupCallBack(result);
                break;
            }
        }
    }

    private void bosOrgCallBack(MessageBoxResult result, String customValue) {
        if (MessageBoxResult.Yes == result) {
            this.setDemandParamEntryByBosOrg();
        } else {
            List oldIds = (List)SerializationUtils.fromJsonString((String)customValue, List.class);
            Object[] idArr = oldIds.stream().map(idStr -> Long.parseLong(idStr)).collect(Collectors.toList()).toArray();
            this.getModel().beginInit();
            this.getModel().setValue("bosorg", (Object)idArr);
            this.getModel().endInit();
            this.getView().updateView("bosorg");
        }
    }

    private void plannerCallBack(MessageBoxResult result) {
        if (MessageBoxResult.Yes == result) {
            this.setFieldValue("plangroup", null);
        } else {
            this.setFieldValue("planner", null);
        }
    }

    private void planGroupCallBack(MessageBoxResult result) {
        if (MessageBoxResult.Yes == result) {
            this.setFieldValue("planner", null);
        } else {
            this.setFieldValue("plangroup", null);
        }
    }

    private void setFieldValue(String field, Object value) {
        this.getModel().beginInit();
        this.getModel().setValue(field, value);
        this.getModel().endInit();
        this.getView().updateView(field);
    }

    private void dimensionCallBack(MessageBoxResult result, String oldId) {
        if (MessageBoxResult.Yes == result) {
            this.initFilterGrid();
            FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
            filterGrid.SetValue(new FilterCondition());
            this.getModel().setValue("invlevelfilter_tag", null);
            this.setMatchDimension();
        } else {
            this.getModel().beginInit();
            this.getModel().setItemValueByID("dimension", (Object)Long.parseLong(oldId));
            this.getModel().endInit();
            this.getView().updateView("dimension");
        }
    }

    private void setMatchDimension() {
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
        if (dimension != null) {
            List<Long> dem2LevelMapIds = this.getDem2LevelMapIds(dimension);
            if (dem2LevelMapIds != null && !dem2LevelMapIds.isEmpty()) {
                this.getModel().setItemValueByID("demtolevelmapping", (Object)dem2LevelMapIds.get(0));
            } else {
                this.getModel().setValue("demtolevelmapping", null);
            }
            List<Long> supToDemMapIds = this.getSupToDemMapIds(dimension);
            if (supToDemMapIds != null && !supToDemMapIds.isEmpty()) {
                this.getModel().setItemValueByID("suptodemmapping", (Object)supToDemMapIds.get(0));
            } else {
                this.getModel().setValue("suptodemmapping", null);
            }
        } else {
            this.getModel().setValue("demtolevelmapping", null);
            this.getModel().setValue("suptodemmapping", null);
        }
    }

    private void changeTarPutBill(int rowIndex) {
        this.getModel().setValue("autoputbotp", null, rowIndex);
    }

    private void changedEntryColName(int rowIndex, String colName, String colSign) {
        String val = (String)this.getModel().getValue(colName, rowIndex);
        if (StringUtils.isBlank((CharSequence)val)) {
            this.getModel().setValue(colSign, null, rowIndex);
        }
    }

    private void changeDemandModel(Object newValue, String targetEntryKey, String propKey, String propName) {
        DynamicObjectCollection dataSrcCfg;
        EntryGrid dataSrcEntity = (EntryGrid)this.getView().getControl(targetEntryKey);
        dataSrcEntity.getModel().deleteEntryData(targetEntryKey);
        if ("supplymodel".equals(propName)) {
            dataSrcEntity.getModel().deleteEntryData("supadjustentry");
        }
        if (newValue == null) {
            if ("demandmodel".equals(propName)) {
                this.getModel().setValue("planadvicemap", null);
            }
            return;
        }
        DynamicObject demandModel = (DynamicObject)newValue;
        if ("demandmodel".equals(propName)) {
            Object outputRes = demandModel.get("outputresult");
            this.getModel().setValue("planadvicemap", outputRes);
        }
        if ((dataSrcCfg = demandModel.getDynamicObjectCollection("entryentityds")).isEmpty()) {
            return;
        }
        if ("supplymodel".equals(propName)) {
            dataSrcCfg.sort((o1, o2) -> {
                if (o1.getDynamicObject("srcbillds").getString("id").equals("im_inv_realbalance")) {
                    return -1;
                }
                return 1;
            });
        }
        this.batchCreateEntryRows(dataSrcEntity, targetEntryKey, dataSrcCfg.getRowCount());
        this.setEntryValue(dataSrcEntity, dataSrcCfg, propKey);
        if ("supplymodel".equals(propName)) {
            this.batchCreateEntryRows(dataSrcEntity, "supadjustentry", dataSrcCfg.getRowCount());
            this.setEntryValue(dataSrcEntity, dataSrcCfg, "entitytype");
        }
    }

    private void batchCreateEntryRows(EntryGrid dataSrcEntity, String targetEntryKey, int rowCount) {
        int dataSrcEntityCount = this.getModel().getEntryRowCount(targetEntryKey);
        if (dataSrcEntityCount < rowCount) {
            dataSrcEntity.getModel().batchCreateNewEntryRow(targetEntryKey, rowCount - dataSrcEntityCount);
        }
    }

    private void setEntryValue(EntryGrid dataSrcEntity, DynamicObjectCollection dataSrcCfg, String propKey) {
        int row = 0;
        for (DynamicObject dynamicObject : dataSrcCfg) {
            DynamicObject srcBill = dynamicObject.getDynamicObject("srcbillds");
            dataSrcEntity.getModel().setValue(propKey, (Object)srcBill, row++);
        }
    }

    private void changeDemandOrg(int rowIndex) {
        this.getModel().setValue("entrysupplypolicy", null, rowIndex);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "algorithmplan": {
                this.beforeAlgorithmPlanSelect(e);
                break;
            }
            case "entrydemandorg": {
                this.beforeDemandOrgSelect(e);
                break;
            }
            case "entrysupplypolicy": {
                this.beforeSupplyPolicySelect(e);
                break;
            }
            case "demandmodel": {
                this.beforeDemSupModelSelect(e, "invp_demand_model");
                break;
            }
            case "supplymodel": {
                this.beforeDemSupModelSelect(e, "invp_supply_model");
                break;
            }
            case "suptodemmapping": {
                this.beforeSup2DemMapSelect(e);
                break;
            }
            case "demtolevelmapping": {
                this.beforeDem2LevelMapSelect(e);
                break;
            }
            case "autoputbotp": {
                this.beforeAutoPutBotpSelect(e);
                break;
            }
            case "planner": {
                this.beforePlannerSelect(e);
                break;
            }
            case "plangroup": {
                this.beforePlanGroupSelect(e);
                break;
            }
        }
    }

    private void beforeDem2LevelMapSelect(BeforeF7SelectEvent e) {
        this.beforeMappingSelect(e, "invp_invlevel", "invp_demand_model");
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
        List<Long> dem2LevelMapIds = this.getDem2LevelMapIds(dimension);
        if (dem2LevelMapIds != null && !dem2LevelMapIds.isEmpty()) {
            QFilter filter = new QFilter("id", "in", dem2LevelMapIds);
            e.addCustomQFilter(filter);
        } else {
            QFilter filter = new QFilter("1", "!=", (Object)"1", true);
            e.addCustomQFilter(filter);
        }
    }

    private void beforeSup2DemMapSelect(BeforeF7SelectEvent e) {
        this.beforeMappingSelect(e, "invp_supply_model", "invp_demand_model");
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
        List<Long> supToDemMapIds = this.getSupToDemMapIds(dimension);
        if (supToDemMapIds != null && !supToDemMapIds.isEmpty()) {
            QFilter filter = new QFilter("id", "in", supToDemMapIds);
            e.addCustomQFilter(filter);
        } else {
            QFilter filter = new QFilter("1", "!=", (Object)"1", true);
            e.addCustomQFilter(filter);
        }
    }

    private void beforePlanGroupSelect(BeforeF7SelectEvent e) {
        MulBasedataDynamicObjectCollection orgs = (MulBasedataDynamicObjectCollection)this.getModel().getValue("bosorg");
        if (orgs != null && !orgs.isEmpty()) {
            List orgIds = orgs.stream().map(org -> org.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", orgIds, (boolean)true);
            e.getCustomQFilters().add(orgFilter);
        }
    }

    private void beforePlannerSelect(BeforeF7SelectEvent e) {
        MulBasedataDynamicObjectCollection orgs = (MulBasedataDynamicObjectCollection)this.getModel().getValue("bosorg");
        if (orgs != null && !orgs.isEmpty()) {
            QFilter enableFilter;
            QFilter filterGridFilter = new QFilter("operatorgrouptype", "=", (Object)"JHZ");
            List orgIds = orgs.stream().map(org -> org.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            QFilter operatorGroupIdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", orgIds, (boolean)true);
            Map currentBizOrgBizOperatorGroup = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id", (QFilter[])new QFilter[]{filterGridFilter, operatorGroupIdFilter, enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE)});
            if (currentBizOrgBizOperatorGroup != null && !currentBizOrgBizOperatorGroup.isEmpty()) {
                HashSet keySet = new HashSet(currentBizOrgBizOperatorGroup.keySet());
                QFilter qFilter = new QFilter("operatorgrpid", "in", new ArrayList(keySet));
                QFilter qFilter1 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
                e.addCustomQFilter(qFilter.and(qFilter1));
            } else if (currentBizOrgBizOperatorGroup == null || currentBizOrgBizOperatorGroup.isEmpty()) {
                e.addCustomQFilter(new QFilter("operatorgrpid", "in", null));
            }
        }
    }

    private void beforeAutoPutBotpSelect(BeforeF7SelectEvent e) {
        DynamicObject demModel = (DynamicObject)this.getModel().getValue("demandmodel");
        if (demModel == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u9700\u6c42\u6a21\u578b\u3002", (String)"InvpSchemeEditPlugin_7", (String)"scmc-invp-form", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        DynamicObject outputType = demModel.getDynamicObject("outputtype");
        if (outputType == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u9700\u6c42\u6a21\u578b,\u8f93\u51fa\u7ed3\u679c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5f55\u5165\u7684\u9700\u6c42\u6a21\u578b\u6570\u636e\u3002", (String)"InvpSchemeEditPlugin_9", (String)"scmc-invp-form", (Object[])new Object[0]), demModel.getString("number")));
            e.setCancel(true);
            return;
        }
        Object targetBill = this.getModel().getValue("targetputbill", e.getRow());
        if (targetBill == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6295\u653e\u751f\u6210\u76ee\u6807\u5355\u3002", (String)"InvpSchemeEditPlugin_10", (String)"scmc-invp-form", (Object[])new Object[0]), demModel.getString("number")));
            e.setCancel(true);
            return;
        }
        DynamicObject targetBillDy = (DynamicObject)targetBill;
        QFilter qFilter = new QFilter("sourceentitynumber", "=", outputType.getPkValue());
        qFilter.and("targetentitynumber", "=", targetBillDy.getPkValue());
        qFilter.and("enabled", "=", (Object)"1");
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        listShowParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void beforeMappingSelect(BeforeF7SelectEvent e, String entityOne, String entityTwo) {
        QFilter qFilter1 = new QFilter("tgtentity", "=", (Object)entityOne);
        QFilter qFilter2 = new QFilter("srcentity", "=", (Object)entityTwo);
        QFilter qFilter3 = qFilter1.and(qFilter2);
        QFilter qFilter4 = new QFilter("tgtentity", "=", (Object)entityTwo);
        QFilter qFilter5 = new QFilter("srcentity", "=", (Object)entityOne);
        QFilter qFilter6 = qFilter4.and(qFilter5);
        e.addCustomQFilter(qFilter3.or(qFilter6));
    }

    private void beforeDemSupModelSelect(BeforeF7SelectEvent e, String modelType) {
        Object planOrg = this.getModel().getValue("createorg");
        if (planOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u8ba1\u5212\u7ec4\u7ec7\u3002", (String)"InvpSchemeEditPlugin_0", (String)"scmc-invp-form", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        QFilter filter = new QFilter("businessentity", "=", (Object)modelType);
        QFilter baseDataFilter = this.getPlanOrgBaseDataFilter(e, "invp_model_register");
        if (baseDataFilter != null) {
            filter.and(baseDataFilter);
        } else {
            filter.and("enable", "=", (Object)"1");
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(filter);
    }

    private void beforeSupplyPolicySelect(BeforeF7SelectEvent e) {
        int row = e.getRow();
        Object demOrg = this.getModel().getValue("entrydemandorg", row);
        if (demOrg == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4fe1\u606f\u7b2c%s\u884c\uff0c\u8bf7\u5148\u586b\u5199\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"InvpSchemeEditPlugin_4", (String)"scmc-invp-form", (Object[])new Object[0]), row + 1));
            e.setCancel(true);
            return;
        }
        DynamicObject demandOrg = (DynamicObject)demOrg;
        QFilter qFilter = new QFilter("demandorgunit.id", "=", demandOrg.getPkValue());
        qFilter.and("enable", "=", (Object)"1");
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        listShowParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void beforeDemandOrgSelect(BeforeF7SelectEvent e) {
        DynamicObject entity = this.getModel().getDataEntity(true);
        if (entity == null || entity.getDynamicObjectCollection("orgparamentry") == null) {
            return;
        }
        DynamicObjectCollection orgEntries = entity.getDynamicObjectCollection("orgparamentry");
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("orgparamentry");
        HashSet<Object> orgIds = new HashSet<Object>(orgEntries.size());
        for (int i = 0; i < orgEntries.size(); ++i) {
            DynamicObject orgEntry = (DynamicObject)orgEntries.get(i);
            DynamicObject invOrg = orgEntry.getDynamicObject("entrydemandorg");
            if (invOrg == null || invOrg.getPkValue() == null || currentRowIndex == i) continue;
            orgIds.add(invOrg.getPkValue());
        }
        if (!orgIds.isEmpty()) {
            ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "not in", orgIds));
        }
    }

    private void beforeAlgorithmPlanSelect(BeforeF7SelectEvent e) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        QFilter filter = this.getPlanOrgBaseDataFilter(e, "invp_algoconfig");
        if (filter == null) {
            return;
        }
        qFilter.and(filter);
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        listShowParameter.getListFilterParameter().setFilter(filter);
    }

    private QFilter getPlanOrgBaseDataFilter(BeforeF7SelectEvent e, String formId) {
        Object planOrg = this.getModel().getValue("createorg");
        if (planOrg != null) {
            DynamicObject planOrgDy = (DynamicObject)planOrg;
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)formId, (Long)((Long)planOrgDy.getPkValue()));
            if (baseDataFilter != null) {
                qFilter.and(baseDataFilter);
            }
            return qFilter;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u8ba1\u5212\u7ec4\u7ec7\u3002", (String)"InvpSchemeEditPlugin_0", (String)"scmc-invp-form", (Object[])new Object[0]));
        e.setCancel(true);
        return null;
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String key;
        super.beforeFieldPostBack(e);
        switch (key = e.getKey()) {
            case "autoupdateinvlevel": 
            case "calrule": 
            case "genfactorscheme": {
                this.checkPlanTypeMustInput(e);
                break;
            }
        }
    }

    private void checkPlanTypeMustInput(BeforeFieldPostBackEvent e) {
        int rowIndex = e.getRowIndex();
        Object value = this.getModel().getValue("plantype", rowIndex);
        if (value == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201d\u8ba1\u5212\u7c7b\u578b\u201c\u3002", (String)"InvpSchemeEditPlugin_2", (String)"scmc-invp-form", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    private List<Long> getSupToDemMapIds(DynamicObject dimension) {
        Set<String> dimensions = InvpSchemeEditPlugin.getDemandDimensions(dimension);
        QFilter filter = new QFilter("tgtentity", "in", (Object)new String[]{"invp_demand_model", "invp_supply_model"}).and("srcentity", "in", (Object)new String[]{"invp_demand_model", "invp_supply_model"}).and("enable", "=", (Object)"1");
        Map mappings = BusinessDataServiceHelper.loadFromCache((String)"invp_matchmapping_config", (String)"id,tgtentity.id,srcentity.id,matchentry.tgtmatchfieldkey,matchentry.srcmatchfieldkey", (QFilter[])filter.toArray());
        List mappingList = mappings.values().stream().filter(mapInfo -> {
            HashSet<String> cols = new HashSet<String>();
            String tarEntity = mapInfo.getString("tgtentity.id");
            DynamicObjectCollection colMap = mapInfo.getDynamicObjectCollection("matchentry");
            for (DynamicObject col : colMap) {
                if ("invp_demand_model".equals(tarEntity)) {
                    cols.add(col.getString("tgtmatchfieldkey"));
                    continue;
                }
                cols.add(col.getString("srcmatchfieldkey"));
            }
            return dimensions.size() == cols.size() && cols.removeAll(dimensions) && cols.isEmpty();
        }).collect(Collectors.toList());
        return mappingList.stream().map(mapInfo -> mapInfo.getLong("id")).collect(Collectors.toList());
    }

    private List<Long> getDem2LevelMapIds(DynamicObject dimension) {
        HashSet<String> dimensions = new HashSet<String>();
        DynamicObjectCollection entries = dimension.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entries) {
            String entityNum = entry.getDynamicObject("associationobject").getString("number");
            if ("bd_materialgroupstandard".equals(entityNum)) continue;
            dimensions.add(entityNum);
        }
        QFilter filter = new QFilter("tgtentity", "in", (Object)new String[]{"invp_demand_model", "invp_invlevel"}).and("srcentity", "in", (Object)new String[]{"invp_demand_model", "invp_invlevel"}).and("enable", "=", (Object)"1");
        Map matchConfigs = BusinessDataServiceHelper.loadFromCache((String)"invp_matchmapping_config", (String)"id,tgtentity.id,srcentity.id,matchentry.tgtmatchfieldkey,matchentry.srcmatchfieldkey", (QFilter[])filter.toArray());
        List matchConfigList = matchConfigs.values().stream().filter(matchConfig -> {
            HashSet<String> cols = new HashSet<String>();
            String tarEntity = matchConfig.getString("tgtentity.id");
            DynamicObjectCollection matchEntries = matchConfig.getDynamicObjectCollection("matchentry");
            for (DynamicObject entry : matchEntries) {
                if ("invp_invlevel".equals(tarEntity)) {
                    cols.add(entry.getString("tgtmatchfieldkey"));
                    continue;
                }
                cols.add(entry.getString("srcmatchfieldkey"));
            }
            return dimensions.size() == cols.size() && cols.removeAll(dimensions) && cols.isEmpty();
        }).collect(Collectors.toList());
        return matchConfigList.stream().map(mapInfo -> mapInfo.getLong("id")).collect(Collectors.toList());
    }

    private static Set<String> getDemandDimensions(DynamicObject dimension) {
        HashSet<String> dimensions = new HashSet<String>();
        DynamicObjectCollection entries = dimension.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entries) {
            String entityNum;
            switch (entityNum = entry.getDynamicObject("associationobject").getString("number")) {
                case "bd_materialgroup": 
                case "bd_material": {
                    dimensions.add("materiel");
                    break;
                }
                case "bos_org": {
                    dimensions.add("org");
                    break;
                }
                case "bd_warehouse": {
                    dimensions.add("demandwarehouse");
                    break;
                }
            }
        }
        return dimensions;
    }
}

