/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.formplugin;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.invp.common.Lang.InvpLang;

public class ScheduleSchemeEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addBeforeF7Listener("org", "planscheme");
    }

    private void addBeforeF7Listener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(key);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Set<Long> planViewOrgIds;
        super.afterCreateNewData(e);
        Object org = this.getModel().getValue("org");
        if (org != null && ((planViewOrgIds = this.getOrgIdsByPlanView()).isEmpty() || !planViewOrgIds.contains(((DynamicObject)org).getPkValue()))) {
            this.getModel().setValue("org", null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
        ListFilterParameter listFilterParameter = param.getListFilterParameter();
        switch (key) {
            case "org": {
                param.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
                QFilter idFilter = new QFilter("id", "in", this.getOrgIdsByPlanView());
                listFilterParameter.getQFilters().add(idFilter);
                break;
            }
            case "planscheme": {
                Object org = this.getModel().getValue("org");
                if (org == null) {
                    this.getView().showTipNotification(InvpLang.plsSelectedValue("invp_schedule_scheme", "org"));
                    evt.setCancel(true);
                    break;
                }
                listFilterParameter.getQFilters().add(this.buildF7Filter((String)this.getModel().getValue("schemetype"), ((DynamicObject)org).getPkValue()));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String changeKey = e.getProperty().getName();
        if ("org".equals(changeKey)) {
            this.getModel().setValue("planscheme", null);
        }
    }

    private Set<Long> getOrgIdsByPlanView() {
        HashSet<Long> idSet = new HashSet<Long>(16);
        QFilter viewfilter = new QFilter("view", "=", (Object)914427355726916608L);
        QFilter ctrlfilter = new QFilter("isctrlunit", "=", (Object)Boolean.TRUE);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"InvpPlanEditPlugin", (String)"bos_org_structure", (String)"org,isctrlunit", (QFilter[])new QFilter[]{viewfilter, ctrlfilter}, null);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            long id = row.getLong("org");
            idSet.add(id);
        }
        return idSet;
    }

    private QFilter buildF7Filter(String key, Object orgId) {
        QFilter qFilter = null;
        qFilter = new QFilter("createorg", "=", orgId).and(new QFilter("enable", "=", (Object)"1"));
        if ("invp_scheme".equals(key)) {
            qFilter.and(new QFilter("status", "=", (Object)"C"));
        }
        return qFilter;
    }
}

