/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.formplugin.list;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.invp.business.InvpInitModelHelper;
import kd.scmc.invp.common.helper.PlanViewOrgHelper;

public class ScheduleSchemeListPlugin
extends AbstractListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        PlanViewOrgHelper.setDefaultOrgItem("invp_schedule_scheme", commonFilterColumns, "org");
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String field = args.getFieldName();
        if (field != null && field.contains("org")) {
            Set<Long> orgIds = InvpInitModelHelper.getOrgIdsByPlanView();
            QFilter orgFilter = new QFilter("id", "in", orgIds);
            args.addCustomQFilter(orgFilter);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        if ("schemejob_number".equals(fieldName)) {
            args.setCancel(true);
            Object currentRowPk = ((BillList)args.getHyperLinkClickEvent().getSource()).getFocusRowPkId();
            DynamicObject schemeJob = QueryServiceHelper.queryOne((String)"invp_schedule_scheme", (String)"schemejob", (QFilter[])new QFilter("id", "=", currentRowPk).toArray());
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("sch_job");
            showParameter.setAppId("invp");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setPkId(schemeJob.get("schemejob"));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if ("queryschemetask".equals(opKey) && args.getOperationResult().isSuccess()) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            this.showSchemeTaskForm(selectedRows.getPrimaryKeyValues());
        }
    }

    private void showSchemeTaskForm(Object[] selectedRowIds) {
        DynamicObjectCollection selectedDatas = QueryServiceHelper.query((String)"invp_schedule_scheme", (String)"id, schemejob.id as schemejobid", (QFilter[])new QFilter("id", "in", (Object)selectedRowIds).toArray());
        HashSet<Object> schemeJobIds = new HashSet<Object>(selectedDatas.size());
        for (DynamicObject selectedRow : selectedDatas) {
            schemeJobIds.add(selectedRow.get("schemejobid"));
        }
        DynamicObjectCollection schemeTasks = QueryServiceHelper.query((String)"sch_schedule", (String)"id", (QFilter[])new QFilter("entryentity.jobnumber.id", "in", schemeJobIds).toArray());
        HashSet<Object> schemeTaskIds = new HashSet<Object>(schemeTasks.size());
        for (DynamicObject schemeTask : schemeTasks) {
            schemeTaskIds.add(schemeTask.get("id"));
        }
        if (schemeTaskIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u7684\u8c03\u5ea6\u8ba1\u5212\u3002", (String)"ScheduleSchemeListPlugin_0", (String)"scmc-invp-form", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_treelist");
        showParameter.setBillFormId("sch_schedule");
        showParameter.setAppId("invp");
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", schemeTaskIds));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

