/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.opplugin;

import java.util.ArrayList;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.scmc.invp.common.consts.InvPlanLogConstants;
import kd.scmc.invp.common.helper.InvPlanHelper;
import kd.scmc.invp.common.helper.InvpLogHelper;

public class InvPlanStopOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add(InvPlanLogConstants.STATUS);
        e.getFieldKeys().add(InvPlanLogConstants.CAL_NUM);
        e.getFieldKeys().add(InvPlanLogConstants.PLAN_ORG);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        String msg = InvPlanHelper.loadKDString("\u72b6\u6001\u4e0d\u4e3a\u8fd0\u884c\u4e2d\uff0c\u4e0d\u80fd\u624b\u5de5\u7ec8\u6b62\u3002", "InvPlanStopOp_0", new Object[0]);
        for (DynamicObject invPlanLogInfo : dataEntities) {
            String status = invPlanLogInfo.getString(InvPlanLogConstants.STATUS);
            if (!InvPlanLogConstants.STATUS_RUNNING.equals(status)) {
                throw new KDBizException(msg);
            }
            String calNum = invPlanLogInfo.getString(InvPlanLogConstants.CAL_NUM);
            invPlanLogInfo.set(InvPlanLogConstants.STATUS, (Object)InvPlanLogConstants.STATUS_USER_STOP);
            InvPlanStopOp.setStatus(calNum);
            this.updateInvPlanLog(invPlanLogInfo.getLong("id"));
            InvpLogHelper.clear(calNum);
            String tenantId = RequestContext.get().getTenantId();
            Object planOrgId = invPlanLogInfo.getDynamicObject(InvPlanLogConstants.PLAN_ORG).getPkValue();
            DLock.forceClear((String[])new String[]{tenantId + "-invplan-" + planOrgId});
        }
    }

    private static void setStatus(String calNum) {
        DistributeSessionlessCache sessionLessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("invPlanCalc");
        if (sessionLessCache.contains(calNum)) {
            sessionLessCache.put(calNum, (Object)InvPlanLogConstants.STATUS_USER_STOP);
        }
    }

    private void updateInvPlanLog(long logId) {
        ArrayList<Long> paramList = new ArrayList<Long>();
        paramList.add(logId);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(" UPDATE T_INVP_PLANLOG SET FSTATUS = 'D' WHERE FID = ?");
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)sqlBuilder.toString(), (Object[])paramList.toArray());
    }
}

