/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.opplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.formula.FormulaEngine;
import kd.scmc.invp.common.helper.InvpCalcRuleHelper;

public class InvpCalcRuleSaveOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject dataEntity : e.getDataEntities()) {
            this.parseLevelFactors(dataEntity);
        }
    }

    private void parseLevelFactors(DynamicObject dataEntity) {
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("calcruleentry");
        for (DynamicObject row : rows) {
            String json = row.getString("calcrulejson_tag");
            if (StringUtils.isBlank((CharSequence)json)) continue;
            DynamicObjectCollection factors = row.getDynamicObjectCollection("levelfactors");
            CRFormula formulaObj = (CRFormula)SerializationUtils.fromJsonString((String)json, CRFormula.class);
            String[] vars = FormulaEngine.extractVariables((String)formulaObj.getExpression());
            DynamicObjectCollection factorIdList = new DynamicObjectCollection();
            for (String var : vars) {
                Long factorId = InvpCalcRuleHelper.getFactorId(var);
                DynamicObject factor = new DynamicObject(factors.getDynamicObjectType());
                factor.set("fbasedataId", (Object)factorId);
                factorIdList.add((Object)factor);
            }
            row.set("levelfactors", (Object)factorIdList);
        }
    }
}

