/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.opplugin;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.invp.common.helper.InvPlanHelper;
import kd.scmc.invp.validator.InvpInvLevelSaveValidator;

public class InvpInvLevelSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("status");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new InvpInvLevelSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills;
        for (DynamicObject bill : bills = e.getDataEntities()) {
            this.doBillAlgorithm(bill);
        }
    }

    private void doBillAlgorithm(DynamicObject bill) {
        String mainPlanType = bill.getString("mainplantype");
        BigDecimal preProcessTime = bill.getBigDecimal("preprocessingtime");
        BigDecimal deliveryTime = bill.getBigDecimal("deliverytime");
        BigDecimal postProcessTime = bill.getBigDecimal("postprocessingtime");
        BigDecimal leadTime = bill.getBigDecimal("leadtime");
        if (leadTime.compareTo(BigDecimal.ZERO) == 0) {
            leadTime = preProcessTime.add(deliveryTime).add(postProcessTime);
            bill.set("leadtime", (Object)leadTime);
        }
        if ("D".equals(mainPlanType)) {
            DynamicObjectCollection supplyDays = bill.getDynamicObjectCollection("supplyday");
            Calendar calendar = Calendar.getInstance();
            if (supplyDays == null || supplyDays.isEmpty()) {
                bill.set("orderperiod", (Object)BigDecimal.ZERO);
            } else {
                List<Integer> supplyDayList = supplyDays.stream().map(supplyDay -> supplyDay.getDynamicObject("fbasedataid").getInt("value")).collect(Collectors.toList());
                supplyDayList.sort(Comparator.comparingInt(obj -> obj));
                String supplyType = bill.getString("supplytype");
                if (supplyType.equals("A")) {
                    int currentDay = InvPlanHelper.castWeekDay(calendar.get(7));
                    int orderPeriod = InvPlanHelper.getOrderPeriod(currentDay, supplyDayList, 7, 7);
                    bill.set("orderperiod", (Object)new BigDecimal(orderPeriod).setScale(0));
                } else {
                    int curDayCount = calendar.getActualMaximum(5);
                    calendar.add(2, 1);
                    int nextDayCount = calendar.getActualMaximum(5);
                    int orderPeriod = InvPlanHelper.getOrderPeriod(calendar.get(5), supplyDayList, curDayCount, nextDayCount);
                    bill.set("orderperiod", (Object)new BigDecimal(orderPeriod).setScale(0));
                }
            }
            BigDecimal safeInvDays = bill.getBigDecimal("safeinvdays");
            BigDecimal urgentInvDays = bill.getBigDecimal("urgentinvdays");
            if (urgentInvDays.compareTo(BigDecimal.ZERO) == 0) {
                urgentInvDays = safeInvDays.add(leadTime);
                bill.set("urgentinvdays", (Object)urgentInvDays);
            }
            BigDecimal orderPeriod = bill.getBigDecimal("orderperiod");
            BigDecimal tarInvDays = bill.getBigDecimal("tgtinvdays");
            if (tarInvDays.compareTo(BigDecimal.ZERO) == 0) {
                tarInvDays = safeInvDays.add(leadTime).add(orderPeriod);
                bill.set("tgtinvdays", (Object)tarInvDays);
            }
        }
        if ("A".equals(mainPlanType)) {
            BigDecimal dailyConsume = bill.getBigDecimal("dailyconsume");
            BigDecimal safeInv = bill.getBigDecimal("safeinv");
            BigDecimal reOrder = bill.getBigDecimal("reorder");
            if (reOrder.compareTo(BigDecimal.ZERO) == 0) {
                reOrder = dailyConsume.multiply(leadTime).add(safeInv);
                bill.set("reorder", (Object)reOrder);
            }
        }
    }
}

