/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.opplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.operation.entryrowop.model.EntryRowOpArgs;
import kd.bos.ext.scmc.plugin.operation.IEntryRowOpFormPlugin;
import kd.bos.form.IFormView;

public class InvpPlanAdviceSplitRowOp
implements IEntryRowOpFormPlugin {
    private Integer unitPrecision = 10;

    public void calQtyTypeFields(EntryRowOpArgs args) {
        super.calQtyTypeFields(args);
        IFormView billView = args.getView();
        IDataModel model = billView.getModel();
        String entryKey = args.getEntryKey();
        Integer srcRowIndex = args.getSrcRowIndex();
        List newRowIndex = args.getNewRowIndex();
        Map<Integer, BigDecimal> rowQtyMap = this.getRowIndexQtyMapping(model, entryKey, "qty", "baseunit", srcRowIndex, newRowIndex);
        Map<Integer, BigDecimal> rowRemainedQtyMap = this.getRowIndexQtyMapping(model, entryKey, "confirmqty", "baseunit", srcRowIndex, newRowIndex);
        if (rowQtyMap.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u884c\u672a\u586b\u5199\u6570\u91cf, \u62c6\u5206\u884c\u6570\u91cf\u5b57\u6bb5\u65e0\u6cd5\u8ba1\u7b97\u3002", (String)"InvpPlanAdviceSplitRowOp_0", (String)"scmc-invp-form", (Object[])new Object[0]));
        }
        this.setQtyValue(model, rowQtyMap, "qty");
        this.setQtyValue(model, rowRemainedQtyMap, "confirmqty");
        billView.updateView(entryKey);
    }

    private Map<Integer, BigDecimal> getRowIndexQtyMapping(IDataModel model, String entryKey, String qtyFieldKey, String unitKey, Integer srcRowIndex, List<Integer> newRowIndex) {
        int rowCount = newRowIndex.size() + 1;
        HashMap<Integer, BigDecimal> rowQtyMap = new HashMap<Integer, BigDecimal>(rowCount);
        DynamicObjectCollection billEntry = model.getDataEntity().getDynamicObjectCollection(entryKey);
        if (billEntry.isEmpty() || newRowIndex.isEmpty()) {
            return rowQtyMap;
        }
        DynamicObject entry = (DynamicObject)billEntry.get(srcRowIndex.intValue());
        BigDecimal srcQty = entry.getBigDecimal(qtyFieldKey);
        if (srcQty == null || BigDecimal.ZERO.compareTo(srcQty) == 0) {
            return rowQtyMap;
        }
        DynamicObject unit = entry.getDynamicObject(unitKey);
        if (unit != null) {
            this.unitPrecision = unit.getInt("precision");
        }
        BigDecimal average = srcQty.divide(new BigDecimal(rowCount), (int)this.unitPrecision, RoundingMode.DOWN);
        BigDecimal multiply = average.multiply(new BigDecimal(newRowIndex.size()));
        BigDecimal lastRowQty = srcQty.subtract(multiply);
        rowQtyMap.put(srcRowIndex, average);
        for (int i = 0; i < newRowIndex.size() - 1; ++i) {
            rowQtyMap.put(newRowIndex.get(i), average);
        }
        rowQtyMap.put(newRowIndex.get(newRowIndex.size() - 1), lastRowQty);
        return rowQtyMap;
    }

    private void setQtyValue(IDataModel model, Map<Integer, BigDecimal> rowQtyMap, String qtyFieldKey) {
        if (rowQtyMap.isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, BigDecimal> entry : rowQtyMap.entrySet()) {
            Integer rowIndex = entry.getKey();
            BigDecimal qtyValue = entry.getValue();
            model.setValue(qtyFieldKey, (Object)qtyValue, rowIndex.intValue());
        }
    }
}

