/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.opplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.invp.common.helper.BalKeyHelper;
import kd.scmc.invp.validator.InvpSafeStockRecSaveValidator;

public class InvpSafeStockRecSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("bos_org");
        fieldKeys.add("bd_material");
        fieldKeys.add("bd_materialgroup");
        fieldKeys.add("bd_materialgroupstandard");
        fieldKeys.add("bd_warehouse");
        fieldKeys.add("dimension");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new InvpSafeStockRecSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            this.calSafeStockDays(dataEntity);
            this.calKeyCol(dataEntity);
        }
    }

    private void calSafeStockDays(DynamicObject dataEntity) {
        Object stock = dataEntity.get("safestock");
        Object consume = dataEntity.get("consumeperday");
        if (stock == null || consume == null) {
            dataEntity.set("safestockdays", null);
            return;
        }
        BigDecimal consumePerDay = new BigDecimal(consume.toString());
        if (consumePerDay.compareTo(BigDecimal.ZERO) == 0) {
            dataEntity.set("safestockdays", null);
            return;
        }
        BigDecimal safeStock = new BigDecimal(stock.toString());
        BigDecimal safeStockDays = safeStock.divide(consumePerDay, 2, RoundingMode.HALF_UP);
        dataEntity.set("safestockdays", (Object)safeStockDays.doubleValue());
    }

    private void calKeyCol(DynamicObject dataEntity) {
        DynamicObject dimension = dataEntity.getDynamicObject("dimension");
        if (dimension == null) {
            return;
        }
        DynamicObjectCollection entryEntity = dimension.getDynamicObjectCollection("entryentity");
        HashMap<String, Object> dimensionMap = new HashMap<String, Object>(4);
        for (DynamicObject entry : entryEntity) {
            String entityNumber = entry.getString("associationobject.number");
            if (StringUtils.isBlank((CharSequence)entityNumber)) continue;
            Object recordDimensionValue = dataEntity.get(entityNumber);
            dimensionMap.put(entityNumber, recordDimensionValue);
        }
        String keyCol = BalKeyHelper.calKeyStr(dimensionMap);
        dataEntity.set("keycol", (Object)keyCol);
    }
}

