/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.opplugin;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scmc.invp.validator.InvpScheduleSchemeDelValidator;

public class InvpScheduleSchemeDelOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new InvpScheduleSchemeDelValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("schemejob");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        super.afterExecuteOperationTransaction(args);
        DynamicObject[] scheduleScheme = args.getDataEntities();
        DynamicObject[] schemeJobs = this.getSchemeJob(scheduleScheme);
        if (schemeJobs.length > 0) {
            try (TXHandle h = TX.requiresNew((String)"invp_schedule_scheme_delete");){
                try {
                    OperationResult delResult = OperationServiceHelper.executeOperate((String)"delete", (String)"sch_job", (DynamicObject[])schemeJobs, (OperateOption)OperateOption.create());
                    if (!delResult.isSuccess()) {
                        throw new KDBizException(delResult.getMessage());
                    }
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    private DynamicObject[] getSchemeJob(DynamicObject[] scheduleSchemes) {
        int len = scheduleSchemes.length;
        DynamicObject[] schemeJobs = new DynamicObject[scheduleSchemes.length];
        for (int i = 0; i < len; ++i) {
            schemeJobs[i] = scheduleSchemes[i].getDynamicObject("schemejob");
        }
        return schemeJobs;
    }
}

