/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.opplugin;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class InvpScheduleSchemeSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("schemejob");
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("name");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] scheduleScheme = args.getDataEntities();
        if (scheduleScheme[0].getDynamicObject("schemejob") == null) {
            Object saveSuccessList;
            block16: {
                DynamicObject schemeJobs = this.createSchemeJobObj(scheduleScheme[0]);
                saveSuccessList = null;
                try (TXHandle h = TX.requiresNew((String)"invp_schedule_scheme_save");){
                    try {
                        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"sch_job", (DynamicObject[])new DynamicObject[]{schemeJobs}, (OperateOption)OperateOption.create());
                        if (saveResult.isSuccess()) {
                            saveSuccessList = saveResult.getSuccessPkIds().get(0);
                            break block16;
                        }
                        throw new KDBizException(saveResult.getMessage());
                    }
                    catch (Throwable e) {
                        h.markRollback();
                        throw e;
                    }
                }
            }
            scheduleScheme[0].set("schemejob", saveSuccessList);
        }
    }

    public DynamicObject createSchemeJobObj(DynamicObject scheduleScheme) {
        RequestContext rs = RequestContext.get();
        Long userId = rs.getCurrUserId();
        Long orgId = rs.getOrgId();
        String scheduleSchemeId = scheduleScheme.getPkValue().toString();
        DynamicObject schemeJob = BusinessDataServiceHelper.newDynamicObject((String)"sch_job");
        schemeJob.set("number", (Object)this.generateNumber(scheduleScheme.getString("number")));
        schemeJob.set("name", (Object)(scheduleScheme.getString("name") + "-" + ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a", (String)"ScheduleSchemeListPlugin_2", (String)"scmc-invp-form", (Object[])new Object[0])));
        schemeJob.set("jobtype", (Object)"BIZ");
        schemeJob.set("taskclassname", (Object)"3H4FQ7MLKHJ1");
        schemeJob.set("classname", (Object)"kd.scmc.invp.business.task.ExecuteInvpPlanTask");
        schemeJob.set("jobprincipal", (Object)userId);
        schemeJob.set("runmode", (Object)"0");
        schemeJob.set("runorder", (Object)"0");
        schemeJob.set("strategy", (Object)"1");
        schemeJob.set("runbyorg", (Object)orgId);
        schemeJob.set("runbyuser", (Object)userId);
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"").append("schemeId").append("\"").append(":").append("\"").append(scheduleSchemeId).append("\"}");
        schemeJob.set("params", (Object)sb.toString());
        schemeJob.set("status", (Object)"1");
        DynamicObjectCollection entryCol = schemeJob.getDynamicObjectCollection("entryentity");
        DynamicObject entryObj = new DynamicObject(entryCol.getDynamicObjectType());
        entryObj.set("paramname", (Object)"schemeId");
        entryObj.set("must", (Object)"1");
        entryObj.set("paramtype", (Object)"0");
        entryObj.set("paramvalue", (Object)scheduleSchemeId);
        entryObj.set("seq", (Object)1);
        entryCol.add((Object)entryObj);
        return schemeJob;
    }

    private String generateNumber(String number) {
        boolean isKingdee = AppMetaServiceHelper.getDeveloperInfo() != null && "kingdee".equals(AppMetaServiceHelper.getDeveloperInfo());
        String appId = "invp";
        if (StringUtils.isNotBlank((CharSequence)appId) && !number.startsWith(appId + "_")) {
            number = appId + "_" + number;
        }
        if (isKingdee) {
            if (!number.endsWith("_SKDJ_S")) {
                number = number.endsWith("_SKDJ") ? number + "_S" : number + "_SKDJ_S";
            }
        } else if (number.endsWith("_SKDJ")) {
            number = number + "_SKDJ";
        }
        return number;
    }
}

