/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class InvpDailyAvgConsumptionMatchMappingSaveValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(InvpDailyAvgConsumptionMatchMappingSaveValidator.class);
    private Map<Object, DynamicObject> matchCfgDymMap = new HashMap<Object, DynamicObject>(16);
    private Map<Object, DynamicObject> dimensionDymMap = new HashMap<Object, DynamicObject>(16);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        this.cacheData();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.checkLevelToMatchCfgMapping(dataEntity);
        }
    }

    private void cacheData() {
        HashSet<Object> matchCfgPks = new HashSet<Object>(this.dataEntities.length);
        HashSet<Object> dimensionPks = new HashSet<Object>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dimension;
            DynamicObject safeStockDym = dataEntity.getDataEntity();
            DynamicObject matchCfg = safeStockDym.getDynamicObject("matchdimension");
            if (matchCfg != null) {
                matchCfgPks.add(matchCfg.getPkValue());
            }
            if ((dimension = safeStockDym.getDynamicObject("dimension")) == null) continue;
            dimensionPks.add(dimension.getPkValue());
        }
        this.matchCfgDymMap = BusinessDataServiceHelper.loadFromCache((Object[])matchCfgPks.toArray(), (String)"invp_matchmapping_config");
        this.dimensionDymMap = BusinessDataServiceHelper.loadFromCache((Object[])dimensionPks.toArray(), (String)"msplan_plan_dimension");
    }

    private void checkLevelToMatchCfgMapping(ExtendedDataEntity dataEntity) {
        DynamicObject matchCfg;
        DynamicObject safeStockDym = dataEntity.getDataEntity();
        DynamicObject dimension = safeStockDym.getDynamicObject("dimension");
        if (!this.checkBaseData(dataEntity, dimension, matchCfg = safeStockDym.getDynamicObject("matchdimension"))) {
            return;
        }
        matchCfg = this.matchCfgDymMap.get(matchCfg.getPkValue());
        dimension = this.dimensionDymMap.get(dimension.getPkValue());
        Map<String, String> dimensionMap = this.getDimensions(dimension, dataEntity);
        this.checkMatchCfg(dataEntity, matchCfg, dimensionMap);
    }

    private boolean checkBaseData(ExtendedDataEntity dataEntity, DynamicObject dimension, DynamicObject matchCfg) {
        boolean flag = false;
        if (dimension == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u3002", (String)"InvpSafeStockSaveValidator_0", (String)"scmc-invp-form", (Object[])new Object[0]));
            flag = true;
        }
        if (matchCfg == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5339\u914d\u7ef4\u5ea6\u6620\u5c04\u3002", (String)"InvpSafeStockSaveValidator_1", (String)"scmc-invp-form", (Object[])new Object[0]));
            flag = true;
        }
        if (flag) {
            return false;
        }
        if (this.matchCfgDymMap.get(matchCfg.getPkValue()) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff0c\u6ca1\u6709\u67e5\u5bfb\u5230\u5bf9\u5e94\u7684\u5339\u914d\u7ef4\u5ea6\u6620\u5c04\u3002", (String)"InvpSafeStockSaveValidator_3", (String)"scmc-invp-form", (Object[])new Object[0]));
        }
        if (this.dimensionDymMap.get(dimension.getPkValue()) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff0c\u6ca1\u6709\u67e5\u5bfb\u5230\u5bf9\u5e94\u7684\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u3002", (String)"InvpSafeStockSaveValidator_5", (String)"scmc-invp-form", (Object[])new Object[0]));
        }
        return true;
    }

    private void checkMatchCfg(ExtendedDataEntity dataEntity, DynamicObject matchCfg, Map<String, String> dimensionMap) {
        DynamicObject targetEntity = matchCfg.getDynamicObject("tgtentity");
        String fieldKey = "";
        String fieldKeyName = "";
        if ("invp_invlevel".equals(targetEntity.get("number"))) {
            fieldKey = "tgtmatchfieldkey";
            fieldKeyName = ResManager.loadKDString((String)"\u76ee\u6807\u5b9e\u4f53\u5b57\u6bb5", (String)"InvpSafeStockSaveValidator_6", (String)"scmc-invp-form", (Object[])new Object[0]);
        } else {
            fieldKey = "srcmatchfieldkey";
            fieldKeyName = ResManager.loadKDString((String)"\u6765\u6e90\u5b9e\u4f53\u5b57\u6bb5", (String)"InvpSafeStockSaveValidator_7", (String)"scmc-invp-form", (Object[])new Object[0]);
        }
        HashSet<String> dimensions = new HashSet<String>(dimensionMap.keySet());
        HashSet<String> levelFields = new HashSet<String>(16);
        DynamicObjectCollection matchEntry = matchCfg.getDynamicObjectCollection("matchentry");
        for (int i = 0; i < matchEntry.size(); ++i) {
            DynamicObject entry = (DynamicObject)matchEntry.get(i);
            String matchEntryKey = entry.getString(fieldKey);
            if (!levelFields.add(matchEntryKey)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5339\u914d\u7ef4\u5ea6\u6620\u5c04\u5206\u5f55\u7b2c%1$s\u884c\uff0c%2$s\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5f55\u5165\u3002", (String)"InvpSafeStockSaveValidator_11", (String)"scmc-invp-form", (Object[])new Object[0]), i + 1, fieldKeyName));
                continue;
            }
            if (matchEntryKey.contains("entryentity")) {
                matchEntryKey = matchEntryKey.substring(matchEntryKey.indexOf(".") + 1);
            }
            if (dimensions.remove(matchEntryKey)) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5339\u914d\u7ef4\u5ea6\u6620\u5c04\u5206\u5f55\u7b2c%1$s\u884c\uff0c%2$s\u5fc5\u987b\u4e3a\u5e93\u5b58\u6c34\u4f4d\u4fe1\u606f\u4e2d\u7684\u6c34\u4f4d\u7ef4\u5ea6\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5f55\u5165\u3002", (String)"InvpSafeStockSaveValidator_8", (String)"scmc-invp-form", (Object[])new Object[0]), i + 1, fieldKeyName));
        }
        for (String dimension : dimensions) {
            String dimensionName = dimensionMap.get(dimension);
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u6c34\u4f4d\u4fe1\u606f\u7684\u6c34\u4f4d\u7ef4\u5ea6\u201c%1$s\u201d\u5fc5\u987b\u5728\u5339\u914d\u7ef4\u5ea6\u6620\u5c04\u4e2d\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5f55\u5165\u3002", (String)"InvpSafeStockSaveValidator_9", (String)"scmc-invp-form", (Object[])new Object[0]), dimensionName));
        }
    }

    private Map<String, String> getDimensions(DynamicObject dimension, ExtendedDataEntity dataEntity) {
        DynamicObjectCollection dimensions = dimension.getDynamicObjectCollection("entryentity");
        HashMap<String, String> signToNameMap = new HashMap<String, String>();
        for (int i = 0; i < dimensions.size(); ++i) {
            DynamicObject row = (DynamicObject)dimensions.get(i);
            DynamicObject associationObject = row.getDynamicObject("associationobject");
            if (associationObject == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6,\u5206\u5f55\u7b2c%2$s\u884c\u5173\u8054\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5f55\u5165\u3002", (String)"InvpSafeStockSaveValidator_10", (String)"scmc-invp-form", (Object[])new Object[0]), dimension.getLocaleString("number"), i + 1));
                continue;
            }
            String entityKey = associationObject.getString("number");
            if ("bd_materialgroupstandard".equals(entityKey)) continue;
            String dimensionName = row.getString("dimensionname");
            signToNameMap.put(entityKey, dimensionName);
        }
        return signToNameMap;
    }
}

