/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.validator;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import org.apache.commons.lang3.math.NumberUtils;

public class InvpDailyAvgConsumptionSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            this.checkMatchEntry(dataEntity);
        }
    }

    private void checkMatchEntry(ExtendedDataEntity dataEntity) {
        DynamicObject bill = dataEntity.getDataEntity();
        DynamicObjectCollection rows = bill.getDynamicObjectCollection("matchentry");
        BigDecimal sum = new BigDecimal(0);
        for (DynamicObject row : rows) {
            sum = sum.add(row.getBigDecimal("factor"));
            Integer start = row.getInt("begindate");
            Integer end = row.getInt("enddate");
            if (NumberUtils.compare((int)start, (int)end) < 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f00\u59cb\u5929\u6570\u9700\u5c0f\u4e8e\u7ed3\u675f\u5929\u6570\u3002", (String)"InvpDailyAvgConsumptionSaveValidator_1", (String)"scmc-invp-form", (Object[])new Object[0]));
        }
        if (sum.compareTo(BigDecimal.ONE) != 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7edf\u8ba1\u5468\u671f\u6743\u6570\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e1\u3002", (String)"InvpDailyAvgConsumptionSaveValidator_0", (String)"scmc-invp-form", (Object[])new Object[0]));
        }
    }
}

