/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class InvpEnableValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        set.add("tgtentity");
        set.add("srcentity");
        set.add("enable");
        return set;
    }

    public void validate() {
        this.enableValidate();
    }

    private void enableValidate() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        int dataEntityLen = dataEntities.length;
        HashSet<String> srcEntity = new HashSet<String>(dataEntityLen);
        HashSet<String> tgtEntity = new HashSet<String>(dataEntityLen);
        HashSet<Object> pkValues = new HashSet<Object>(dataEntityLen);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject obj = dataEntity.getDataEntity();
            srcEntity.add(obj.getDynamicObject("srcentity").getString("number"));
            tgtEntity.add(obj.getDynamicObject("tgtentity").getString("number"));
            pkValues.add(dataEntity.getBillPkId());
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and(new QFilter("tgtentity", "in", tgtEntity)).and(new QFilter("srcentity", "in", srcEntity)).and(new QFilter("id", "not in", pkValues));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"invp_matchmapping_config", (String)"id,tgtentity.number as tgtentity,srcentity.number as srcentity", (QFilter[])qFilter.toArray());
        HashMap<String, Set> tgtEntity2SrcEntity = new HashMap<String, Set>(dataEntities.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String queryTgtEntity = dynamicObject.getString("tgtentity");
            String querySrcEntity = dynamicObject.getString("srcentity");
            Set set = tgtEntity2SrcEntity.getOrDefault(queryTgtEntity, new HashSet());
            set.add(querySrcEntity);
            tgtEntity2SrcEntity.put(queryTgtEntity, set);
        }
        if (!tgtEntity2SrcEntity.isEmpty()) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                String tgtEntityStr = dataEntity.getDataEntity().getDynamicObject("tgtentity").getString("number");
                String srcEntityStr = dataEntity.getDataEntity().getDynamicObject("srcentity").getString("number");
                Set srcEntitySet = (Set)tgtEntity2SrcEntity.get(tgtEntityStr);
                if (srcEntitySet == null || !srcEntitySet.contains(srcEntityStr)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u542f\u7528\u4e14\u76ee\u6807\u5b9e\u4f53\u548c\u6e90\u5b9e\u4f53\u76f8\u540c\u7684\u6570\u636e\uff0c\u8bf7\u5148\u7981\u7528\u3002", (String)"InvpEnableValidator_0", (String)"scmc-invp-form", (Object[])new Object[0]));
            }
        }
    }
}

