/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.invp.common.consts.InventoryDimension;
import kd.scmc.invp.common.helper.BalKeyHelper;
import kd.scmc.invp.common.helper.InvpLevelFactorHelper;
import kd.scmc.invp.common.helper.ModelFilterHelper;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;

public class InvpInvLevelDataSaveValidator
extends AbstractValidator {
    public void validate() {
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(Arrays.asList(this.dataEntities));
        if (dataEntityList.size() == 0) {
            return;
        }
        DynamicObject firstData = ((ExtendedDataEntity)dataEntityList.get(0)).getDataEntity();
        IDataEntityType dataEntityType = firstData.getDataEntityType();
        EntryProp entryProp = (EntryProp)dataEntityType.getProperties().get((Object)"entryentity");
        IDataEntityProperty seqProp = ((EntryType)entryProp.getItemType()).getSeqProperty();
        if (seqProp == null) {
            return;
        }
        HashSet<Long> orgSet = new HashSet<Long>(16);
        HashSet<Long> materielSet = new HashSet<Long>(16);
        this.checkBaseData(dataEntityList, orgSet, materielSet);
        this.checkMustInput(dataEntityList);
    }

    private void checkMustInput(List<ExtendedDataEntity> dataEntityList) {
        HashMap<String, Set<IDataEntityProperty>> cacheMap = new HashMap<String, Set<IDataEntityProperty>>(4);
        for (ExtendedDataEntity extendedDataEntity : dataEntityList) {
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            String mainplantype = dynamicObject.getString("mainplantype");
            Set<IDataEntityProperty> mustInputFields = (Set<IDataEntityProperty>)cacheMap.get(mainplantype);
            if (null == mustInputFields) {
                MultiKeyMap<String, Boolean> fieldCtlMap = InvpLevelFactorHelper.loadLevelFactorCtlMap("invp_invleveldata", mainplantype, "ismustinput");
                mustInputFields = this.getMustInputFields(fieldCtlMap);
                cacheMap.put(mainplantype, mustInputFields);
            }
            DynamicObjectCollection rows = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : rows) {
                for (IDataEntityProperty mustInputField : mustInputFields) {
                    String format;
                    String name;
                    Object val = row.get(mustInputField.getName());
                    if (val instanceof BigDecimal && ((BigDecimal)val).compareTo(BigDecimal.ZERO) == 0) {
                        name = (String)mustInputField.getDisplayName().getDefaultItem();
                        format = String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\uff1a\u5b57\u6bb5\u201c%s\u201d\u503c\u9700\u8981\u5927\u4e8e0\u3002", (String)"InvpInvLevelSaveValidator_3", (String)"scmc-invp-form", (Object[])new Object[0]), row.getInt("seq"), name);
                        this.addErrorMessage(extendedDataEntity, format);
                        continue;
                    }
                    if (!(val instanceof Number) || BigDecimal.ZERO.compareTo(new BigDecimal(String.valueOf(val))) != 0) continue;
                    name = (String)mustInputField.getDisplayName().getDefaultItem();
                    format = String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\uff1a\u5b57\u6bb5\u201c%s\u201d\u503c\u9700\u8981\u5927\u4e8e0\u3002", (String)"InvpInvLevelSaveValidator_3", (String)"scmc-invp-form", (Object[])new Object[0]), row.getInt("seq"), name);
                    this.addErrorMessage(extendedDataEntity, format);
                }
            }
        }
    }

    private Set<IDataEntityProperty> getMustInputFields(MultiKeyMap<String, Boolean> fieldCtlMap) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"invp_invleveldata");
        HashSet<IDataEntityProperty> fields = new HashSet<IDataEntityProperty>(fieldCtlMap.size());
        for (Map.Entry entry : fieldCtlMap.entrySet()) {
            String field = (String)((MultiKey)entry.getKey()).getKey(0);
            Boolean isMustInput = (Boolean)entry.getValue();
            DynamicProperty property = RowDataModel.findProperty((MainEntityType)mainEntityType, (String)field);
            if (property == null || !(property.getParent() instanceof EntryType) || !isMustInput.booleanValue()) continue;
            fields.add((IDataEntityProperty)property);
        }
        return fields;
    }

    private void checkBaseData(List<ExtendedDataEntity> dataEntityList, Set<Long> orgSet, Set<Long> materielSet) {
        Iterator<ExtendedDataEntity> iterator = dataEntityList.iterator();
        while (iterator.hasNext()) {
            ExtendedDataEntity dataEntity = iterator.next();
            DynamicObject inventrory = dataEntity.getDataEntity();
            Object dimension = inventrory.getDynamicObject("dimension").getPkValue();
            InventoryDimension dim = new InventoryDimension(dimension);
            DynamicObjectCollection entryentity = inventrory.getDynamicObjectCollection("entryentity");
            List<String> errList = this.checkSaveData(entryentity, dim, orgSet, materielSet);
            if (!errList.isEmpty()) {
                for (String err : errList) {
                    this.addErrorMessage(dataEntity, err);
                }
                iterator.remove();
            }
            this.diffDimension(dataEntity);
        }
    }

    private List<String> checkSaveData(DynamicObjectCollection rows, InventoryDimension dim, Set<Long> orgSet, Set<Long> materielSet) {
        ArrayList<String> errResults = new ArrayList<String>(4);
        Map<String, String> entityToNameMap = dim.getEntityToNameMap();
        boolean hasAll = dim.hasMtAndGrp();
        for (DynamicObject row : rows) {
            int seq = row.getInt("seq");
            if (row.getDynamicObject("bos_org") != null) {
                orgSet.add(row.getDynamicObject("bos_org").getLong("id"));
            }
            if (row.getDynamicObject("bd_material") != null) {
                materielSet.add(row.getDynamicObject("bd_material").getLong("id"));
            }
            for (Map.Entry<String, String> entry : entityToNameMap.entrySet()) {
                DynamicObject val = row.getDynamicObject(entry.getKey());
                if (val != null || hasAll && "bd_material".equals(entry.getKey())) continue;
                String format = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%d\u884c\uff1a\u201c%s\u201d\u3002", (String)"InvpInvLevelDataSaveValidator_1", (String)"scmc-invp-form", (Object[])new Object[0]), seq, entry.getValue());
                errResults.add(format);
            }
            if (errResults.isEmpty()) continue;
        }
        if (errResults.isEmpty()) {
            return Collections.emptyList();
        }
        return errResults;
    }

    private void diffDimension(ExtendedDataEntity dataEntity) {
        DynamicObject invlevelDataDym = dataEntity.getDataEntity();
        HashMap<String, Integer> dimensionMap = new HashMap<String, Integer>(4);
        DynamicObject dimension = ModelFilterHelper.loadFullDym(invlevelDataDym.getDynamicObject("dimension"));
        DynamicObjectCollection dimensions = dimension.getDynamicObjectCollection("entryentity");
        HashSet<String> dimensionFields = new HashSet<String>();
        for (DynamicObject row : dimensions) {
            String entityKey = row.getString("associationobject.number");
            dimensionFields.add(entityKey);
        }
        DynamicObjectCollection rows = invlevelDataDym.getDynamicObjectCollection("entryentity");
        for (int rowIdx = 0; rowIdx < rows.size(); ++rowIdx) {
            DynamicObject row = (DynamicObject)rows.get(rowIdx);
            HashMap<String, Object> keyMap = new HashMap<String, Object>(4);
            for (String dimensionField : dimensionFields) {
                Object val = row.get(dimensionField);
                if (val instanceof DynamicObject) {
                    keyMap.put(dimensionField, ((DynamicObject)val).getPkValue());
                    continue;
                }
                keyMap.put(dimensionField, val);
            }
            String key = BalKeyHelper.calKeyStr(keyMap);
            if (dimensionMap.containsKey(key)) {
                int seq = (Integer)dimensionMap.get(key);
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55{0}\u884c\uff1a\u4e0e\u5206\u5f55\u884c{1}\u6570\u636e\u8303\u56f4\u91cd\u53e0\u3002", (String)"InvpInvLevelDataSaveValidator_0", (String)"scmc-invp-form", (Object[])new Object[]{rowIdx + 1, seq + 1}));
                continue;
            }
            dimensionMap.put(key, rowIdx);
        }
    }
}

