/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.invp.common.helper.InvpLevelFactorHelper;
import kd.scmc.invp.common.helper.MrpMaterialGroupStandardHelper;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;

public class InvpInvLevelSaveValidator
extends AbstractValidator {
    public void validate() {
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(Arrays.asList(this.dataEntities));
        if (dataEntityList.size() == 0) {
            return;
        }
        this.checkImportSave(dataEntityList);
        this.checkMustInput();
    }

    private void checkMustInput() {
        if (this.dataEntities != null) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"invp_invlevel");
            StringBuilder errorBuilder = new StringBuilder();
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                String planType;
                DynamicObject billInfo = dataEntity.getDataEntity();
                DynamicObject dimension = billInfo.getDynamicObject("dimension");
                if (dimension != null) {
                    List<MrpMaterialGroupStandardHelper.InvpInvDimensionEntry> entryList = MrpMaterialGroupStandardHelper.getInventoryDimension(dimension);
                    for (MrpMaterialGroupStandardHelper.InvpInvDimensionEntry entry : entryList) {
                        String entityNumber = entry.getAssociationobject();
                        IDataEntityProperty iDataEntityProperty = entityType.findProperty(entityNumber);
                        if (iDataEntityProperty == null || billInfo.get(iDataEntityProperty) != null) continue;
                        String fieldName = entry.getDimensionname();
                        if (errorBuilder.length() > 0) {
                            errorBuilder.append(",");
                        }
                        errorBuilder.append("\"").append(fieldName).append("\"");
                    }
                }
                if (!StringUtils.isBlank((CharSequence)(planType = billInfo.getString("mainplantype")))) {
                    MultiKeyMap<String, Boolean> cfgMap = InvpLevelFactorHelper.loadLevelFactorCtlMap("invp_invlevel", planType, new String[0]);
                    HashSet<Object> fieldKeys = new HashSet<Object>(4);
                    for (MultiKey multiKey : cfgMap.keySet()) {
                        fieldKeys.add(multiKey.getKey(0));
                    }
                    for (String string : fieldKeys) {
                        IDataEntityProperty property = entityType.findProperty(string);
                        if (null == property) continue;
                        Boolean isshow = (Boolean)cfgMap.get((Object)string, (Object)"isshow");
                        Boolean ismustinput = (Boolean)cfgMap.get((Object)string, (Object)"ismustinput") != false && isshow != false;
                        if (!ismustinput.booleanValue() || billInfo.get(property) != null) continue;
                        String fieldName = property.getName();
                        if (errorBuilder.length() > 0) {
                            errorBuilder.append(",");
                        }
                        errorBuilder.append("\"").append(fieldName).append("\"");
                    }
                }
                if (errorBuilder.length() > 0) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199{0}\u3002", (String)"InvpInvLevelSaveValidator_34", (String)"scmc-invp-form", (Object[])new Object[]{errorBuilder.toString()}), ErrorLevel.Error);
                }
                errorBuilder.setLength(0);
            }
        }
    }

    private void checkImportSave(List<ExtendedDataEntity> dataEntityList) {
        String operateKey = this.getOperateKey();
        Iterator<ExtendedDataEntity> iterator = dataEntityList.iterator();
        while (iterator.hasNext()) {
            ExtendedDataEntity dataEntity = iterator.next();
            String status = dataEntity.getDataEntity().getString("status");
            if (!"save".equals(operateKey) || "A".equals(status)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u7684\u6570\u636e\u624d\u80fd\u4fdd\u5b58\u3002", (String)"InvpInvLevelSaveValidator_0", (String)"scmc-invp-form", (Object[])new Object[0]));
            iterator.remove();
        }
    }
}

