/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.invp.common.consts.InventoryDimension;
import kd.scmc.invp.common.consts.InvpInvLevelConst;
import kd.scmc.invp.common.helper.InvpLevelFactorHelper;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;

public class InvpInvLevelSubmitValidator
extends AbstractValidator {
    private List<String> weekDays = Arrays.asList("z1", "z2", "z3", "z4", "z5", "z6", "z7");

    public Set<String> preparePropertys() {
        Set propertys = super.preparePropertys();
        propertys.add("supplyday");
        propertys.add("supplyday.number");
        propertys.add("supplytype");
        propertys.add("bd_materialgroupstandard");
        return propertys;
    }

    public void validate() {
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(Arrays.asList(this.dataEntities));
        if (dataEntityList.size() == 0) {
            return;
        }
        this.checkBaseData(dataEntityList);
        this.checkLevelFactorFields(dataEntityList);
    }

    private void checkLevelFactorFields(List<ExtendedDataEntity> dataEntityList) {
        for (ExtendedDataEntity dataEntity : dataEntityList) {
            DynamicObject invLevelInfo = dataEntity.getDataEntity();
            String mainPlanType = invLevelInfo.getString("mainplantype");
            MultiKeyMap<String, Boolean> fieldCtlMap = InvpLevelFactorHelper.loadLevelFactorCtlMap("invp_invlevel", mainPlanType, "ismustinput");
            Set<IDataEntityProperty> mustInputFields = this.getMustInputFields(fieldCtlMap);
            for (IDataEntityProperty mustInputField : mustInputFields) {
                Object val = invLevelInfo.get(mustInputField.getName());
                if (val instanceof Number) {
                    BigDecimal value = new BigDecimal(String.valueOf(val));
                    if (BigDecimal.ZERO.compareTo(value) < 0 && value.compareTo(new BigDecimal("999999999")) <= 0) continue;
                    String name = (String)mustInputField.getDisplayName().getDefaultItem();
                    String message = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c{0}\u201d\u503c\u9700\u8981\u5927\u4e8e0\uff0c\u5c0f\u4e8e999999999\u3002", (String)"InvpInvLevelSaveValidator_3", (String)"scmc-invp-form", (Object[])new Object[]{name});
                    this.addErrorMessage(dataEntity, message);
                    continue;
                }
                if (!ObjectUtils.isEmpty((Object)val)) continue;
                String name = (String)mustInputField.getDisplayName().getDefaultItem();
                String message = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\uff1a\u201c{0}\u201d\u3002", (String)"InvpInvLevelSaveValidator_4", (String)"scmc-invp-form", (Object[])new Object[]{name});
                this.addErrorMessage(dataEntity, message);
            }
        }
    }

    private Set<IDataEntityProperty> getMustInputFields(MultiKeyMap<String, Boolean> fieldCtlMap) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"invp_invlevel");
        HashSet<IDataEntityProperty> fields = new HashSet<IDataEntityProperty>(fieldCtlMap.size());
        for (Map.Entry entry : fieldCtlMap.entrySet()) {
            String field = (String)((MultiKey)entry.getKey()).getKey(0);
            Boolean isMustInput = (Boolean)entry.getValue();
            DynamicProperty property = RowDataModel.findProperty((MainEntityType)mainEntityType, (String)field);
            if (property == null || !isMustInput.booleanValue()) continue;
            fields.add((IDataEntityProperty)property);
        }
        return fields;
    }

    private void checkBaseData(List<ExtendedDataEntity> dataEntityList) {
        for (ExtendedDataEntity dataEntity : dataEntityList) {
            List<String> errList = this.checkSaveData(dataEntity.getDataEntity());
            if (errList.isEmpty()) continue;
            for (String err : errList) {
                this.addErrorMessage(dataEntity, err);
            }
        }
    }

    private List<String> checkSaveData(DynamicObject levelInfo) {
        ArrayList<String> errResults;
        block17: {
            String planType;
            block18: {
                String err;
                block16: {
                    errResults = new ArrayList<String>(4);
                    DynamicObject dimension = levelInfo.getDynamicObject("dimension");
                    if (dimension != null) {
                        Long orgId;
                        String message;
                        Object matGroupId;
                        boolean exists;
                        InventoryDimension dim = new InventoryDimension(dimension.getPkValue());
                        Map<String, String> entityToNameMap = dim.getEntityToNameMap();
                        for (Map.Entry<String, String> entry : entityToNameMap.entrySet()) {
                            DynamicObject val = levelInfo.getDynamicObject(entry.getKey());
                            if (val != null) continue;
                            String message2 = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\uff1a\u201c{0}\u201d\u3002", (String)"InvpInvLevelSaveValidator_4", (String)"scmc-invp-form", (Object[])new Object[]{entry.getValue()});
                            errResults.add(message2);
                        }
                        DynamicObject matGroup = levelInfo.getDynamicObject("bd_materialgroup");
                        if (entityToNameMap.containsKey("bd_materialgroup") && entityToNameMap.containsKey("bd_materialgroupstandard")) {
                            Object matGroupStandId;
                            QFilter filter;
                            DynamicObject matStand = levelInfo.getDynamicObject("bd_materialgroupstandard");
                            if (matGroup != null && matStand != null && !(exists = QueryServiceHelper.exists((String)"bd_materialgroup", (QFilter[])(filter = new QFilter("standard", "=", matGroupStandId = matStand.getPkValue()).and("id", "=", matGroupId = matGroup.getPkValue())).toArray()))) {
                                message = ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b\u4e0d\u5728\u5bf9\u5e94\u7684\u7269\u6599\u5206\u7c7b\u6807\u51c6\u4e0b\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"InvpInvLevelSaveValidator_30", (String)"scmc-invp-form", (Object[])new Object[0]);
                                errResults.add(message);
                            }
                        }
                        DynamicObject bosOrg = levelInfo.getDynamicObject("bos_org");
                        if (entityToNameMap.containsKey("bd_warehouse") && entityToNameMap.containsKey("bos_org")) {
                            DynamicObject warehouse = levelInfo.getDynamicObject("bd_warehouse");
                            if (bosOrg != null && warehouse != null) {
                                orgId = bosOrg.getLong("id");
                                QFilter warehouseFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_warehouse", (Long)orgId);
                                exists = QueryServiceHelper.exists((String)"bd_warehouse", (QFilter[])(warehouseFilter = warehouseFilter.and("id", "=", warehouse.getPkValue())).toArray());
                                if (!exists) {
                                    message = ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\u65e0\u5bf9\u5e94\u4ed3\u5e93\u7684\u4f7f\u7528\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"InvpInvLevelSaveValidator_31", (String)"scmc-invp-form", (Object[])new Object[0]);
                                    errResults.add(message);
                                }
                            }
                        }
                        DynamicObject material = levelInfo.getDynamicObject("bd_material");
                        if (entityToNameMap.containsKey("bd_material") && entityToNameMap.containsKey("bos_org") && material != null && bosOrg != null) {
                            orgId = bosOrg.getLong("id");
                            QFilter materialFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)orgId);
                            exists = QueryServiceHelper.exists((String)"bd_material", (QFilter[])(materialFilter = materialFilter.and("id", "=", material.getPkValue())).toArray());
                            if (!exists) {
                                message = ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\u65e0\u5bf9\u5e94\u7269\u6599\u7684\u4f7f\u7528\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"InvpInvLevelSaveValidator_32", (String)"scmc-invp-form", (Object[])new Object[0]);
                                errResults.add(message);
                            }
                        }
                        if (entityToNameMap.containsKey("bd_material") && entityToNameMap.containsKey("bd_materialgroup") && material != null && matGroup != null) {
                            matGroupId = matGroup.getLong("id");
                            Long matId = material.getLong("id");
                            QFilter filter = new QFilter("material", "=", (Object)matId).and("group", "=", matGroupId);
                            boolean exists2 = QueryServiceHelper.exists((String)"bd_materialgroupdetail", (QFilter[])filter.toArray());
                            if (!exists2) {
                                String message3 = ResManager.loadKDString((String)"\u7269\u6599\u4e0d\u5728\u5bf9\u5e94\u7684\u7269\u6599\u5206\u7c7b\u4e0b\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"InvpInvLevelSaveValidator_33", (String)"scmc-invp-form", (Object[])new Object[0]);
                                errResults.add(message3);
                            }
                        }
                    }
                    if (InvpInvLevelConst.PlanType.get(planType = levelInfo.getString("mainplantype")) != InvpInvLevelConst.PlanType.REORDER) break block16;
                    levelInfo.set("max", (Object)0.0);
                    levelInfo.set("min", (Object)0.0);
                    BigDecimal reorder = levelInfo.getBigDecimal("reorder");
                    BigDecimal ecoBatch = levelInfo.getBigDecimal("ecobatch");
                    if (null == reorder || null == ecoBatch || ecoBatch.compareTo(reorder) >= 0) break block17;
                    err = ResManager.loadKDString((String)"\u7ecf\u6d4e\u6279\u91cf\u5fc5\u987b\u5927\u4e8e\u6216\u7b49\u4e8e\u518d\u8ba2\u8d27\u70b9\u3002", (String)"InvpInvLevelSaveValidator_29", (String)"scmc-invp-form", (Object[])new Object[0]);
                    errResults.add(err);
                    break block17;
                }
                if (InvpInvLevelConst.PlanType.get(planType) != InvpInvLevelConst.PlanType.MAXMIN) break block18;
                levelInfo.set("reorder", (Object)0.0);
                levelInfo.set("ecobatch", (Object)0.0);
                levelInfo.set("dailyconsume", (Object)0.0);
                BigDecimal max = levelInfo.getBigDecimal("max");
                BigDecimal min = levelInfo.getBigDecimal("min");
                if (max.compareTo(min) >= 0) break block17;
                err = ResManager.loadKDString((String)"\u6700\u5927\u5e93\u5b58\u5fc5\u987b\u5927\u4e8e\u6216\u7b49\u4e8e\u6700\u5c0f\u5e93\u5b58\u3002", (String)"InvpInvLevelSaveValidator_9", (String)"scmc-invp-form", (Object[])new Object[0]);
                errResults.add(err);
                break block17;
            }
            if (InvpInvLevelConst.PlanType.get(planType) == InvpInvLevelConst.PlanType.FIXEDPEROID) {
                String err;
                String urgentType = levelInfo.getString("supplytype");
                DynamicObjectCollection supplyDays = levelInfo.getDynamicObjectCollection("supplyday");
                if ("A".equals(urgentType)) {
                    for (DynamicObject supplyDay : supplyDays) {
                        String number = supplyDay.getDynamicObject("fbasedataid").getString("number");
                        if (this.weekDays.contains(number)) continue;
                        err = ResManager.loadKDString((String)"\u8865\u8d27\u5468\u671f\u7c7b\u578b=\u5468\uff0c\u8303\u56f4\u4e3a\u661f\u671f\u4e00~\u661f\u671f\u65e5\u3002", (String)"InvpInvLevelSaveValidator_26", (String)"scmc-invp-form", (Object[])new Object[0]);
                        errResults.add(err);
                    }
                } else {
                    for (DynamicObject supplyDay : supplyDays) {
                        int number = Integer.parseInt(supplyDay.getDynamicObject("fbasedataid").getString("number"));
                        if (number >= 1 && number <= 28) continue;
                        err = ResManager.loadKDString((String)"\u8865\u8d27\u5468\u671f\u7c7b\u578b=\u6708\uff0c\u8303\u56f4\u4e3a1~28\u3002", (String)"InvpInvLevelSaveValidator_28", (String)"scmc-invp-form", (Object[])new Object[0]);
                        errResults.add(err);
                    }
                }
            }
        }
        return errResults;
    }
}

