/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.validator;

import java.util.ArrayDeque;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.util.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class InvpMatchConfigSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            this.entryValidate(dataEntity);
        }
    }

    public void entryValidate(ExtendedDataEntity dataEntity) {
        DynamicObject bill = dataEntity.getDataEntity();
        DynamicObjectCollection dynamicObjectCollection = bill.getDynamicObjectCollection("matchentry");
        if (!this.bracketValidate(dynamicObjectCollection)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5de6\u62ec\u53f7\u4e0e\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"InvpMatchConfigEditPlugin_5", (String)"scmc-invp-form", (Object[])new Object[0]));
        }
    }

    public boolean bracketValidate(DynamicObjectCollection dynamicObjectCollection) {
        if (ObjectUtils.isEmpty((Object)dynamicObjectCollection)) {
            return true;
        }
        ArrayDeque<String> stack = new ArrayDeque<String>(dynamicObjectCollection.size());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String[] rightBrackets;
            String rightBracket;
            String leftBracket = dynamicObject.getString("leftbracket");
            if (StringUtils.isNotEmpty((String)leftBracket)) {
                stack.addAll(Arrays.asList(leftBracket.split("")));
            }
            if (!StringUtils.isNotEmpty((String)(rightBracket = dynamicObject.getString("rightbracket")))) continue;
            for (String singleBracket : rightBrackets = rightBracket.split("")) {
                if (stack.pollLast() != null) continue;
                return false;
            }
        }
        return stack.isEmpty();
    }
}

