/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.validator;

import java.util.ArrayDeque;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class InvpQueryRuleSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            this.checkMatchEntry(dataEntity);
        }
    }

    private void checkMatchEntry(ExtendedDataEntity dataEntity) {
        DynamicObject bill = dataEntity.getDataEntity();
        DynamicObjectCollection dynamicObjectCollection = bill.getDynamicObjectCollection("matchentry");
        this.checkMatchGroup(dataEntity, dynamicObjectCollection);
        if (!this.checkBracketMatch(dynamicObjectCollection)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5de6\u62ec\u53f7\u4e0e\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"InvpQueryRuleSaveValidator_0", (String)"scmc-invp-form", (Object[])new Object[0]));
        }
    }

    private void checkMatchGroup(ExtendedDataEntity dataEntity, DynamicObjectCollection entries) {
        for (int rowIdx = 0; rowIdx < entries.size(); ++rowIdx) {
            Object matchGroup;
            DynamicObject entry = (DynamicObject)entries.get(rowIdx);
            String matchType = entry.getString("matchtype");
            if (!"B".equals(matchType) || null != (matchGroup = entry.get("matchgroup"))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5339\u914d\u89c4\u5219\u201d\u7b2c{0}\u884c\uff1a\u201c\u5206\u7ec4\u5173\u7cfb\u201d\u3002", (String)"InvpQueryRuleSaveValidator_1", (String)"scmc-invp-form", (Object[])new Object[]{rowIdx + 1}));
        }
    }

    private boolean checkBracketMatch(DynamicObjectCollection dynamicObjectCollection) {
        if (ObjectUtils.isEmpty((Object)dynamicObjectCollection)) {
            return true;
        }
        ArrayDeque<String> stack = new ArrayDeque<String>(dynamicObjectCollection.size());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String[] rightBrackets;
            String rightBracketStr;
            String leftBracket = dynamicObject.getString("leftbracket");
            if (StringUtils.isNotBlank((CharSequence)leftBracket)) {
                stack.addAll(Arrays.asList(leftBracket.split("")));
            }
            if (!StringUtils.isNotBlank((CharSequence)(rightBracketStr = dynamicObject.getString("rightbracket")))) continue;
            for (String rightBracket : rightBrackets = rightBracketStr.split("")) {
                if ("(".equals(stack.peekLast())) {
                    stack.pollLast();
                    continue;
                }
                stack.push(rightBracket);
            }
        }
        return stack.isEmpty();
    }
}

