/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class InvpSafeStockRecSaveValidator
extends AbstractValidator {
    private Map<Object, List<Long>> orgToHasPermMaterialMap = new HashMap<Object, List<Long>>(64);
    private Map<Object, List<Long>> orgToHasPermMaterialGrpMap = new HashMap<Object, List<Long>>(64);
    private Map<Object, List<Long>> orgToHasPermWarehouseMap = new HashMap<Object, List<Long>>(64);
    private Map<String, QFilter> baseFilterMap = new HashMap<String, QFilter>(8);

    public void validate() {
        HashMap<Object, List<Map<String, String>>> dimensionMap = new HashMap<Object, List<Map<String, String>>>(this.dataEntities.length);
        HashMap<Object, List<Long>> orgToMaterialMap = new HashMap<Object, List<Long>>(64);
        HashMap<Object, List<Long>> orgToWarehouseMap = new HashMap<Object, List<Long>>(64);
        for (ExtendedDataEntity extDataEntity : this.dataEntities) {
            DynamicObject dimension;
            DynamicObject entity = extDataEntity.getDataEntity();
            DynamicObject org = entity.getDynamicObject("bos_org");
            if (org == null || (dimension = entity.getDynamicObject("dimension")) == null) continue;
            this.cacheDimension(entity, dimensionMap);
            this.cacheMaterialGroup(entity, dimensionMap);
            this.cacheBaseDataId(entity, org, dimension.getPkValue(), dimensionMap, orgToMaterialMap);
            this.cacheBaseDataId(entity, org, dimension.getPkValue(), dimensionMap, orgToWarehouseMap);
        }
        this.cacheHasPermBaseData("bd_material", orgToMaterialMap, this.orgToHasPermMaterialMap);
        this.cacheHasPermBaseData("bd_warehouse", orgToWarehouseMap, this.orgToHasPermWarehouseMap);
        this.doValidate(dimensionMap);
    }

    private void doValidate(Map<Object, List<Map<String, String>>> dimensionMap) {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            DynamicObject bosOrg = entity.getDynamicObject("bos_org");
            if (bosOrg == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u4e1a\u52a1\u7ec4\u7ec7\u201d\u3002\n", (String)"InvpSafeStockRecSaveValidator_0", (String)"scmc-invp-form", (Object[])new Object[0]));
                continue;
            }
            String orgNumber = bosOrg.getString("number");
            DynamicObject dimension = entity.getDynamicObject("dimension");
            if (dimension == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u201d\u3002\n", (String)"InvpSafeStockRecSaveValidator_3", (String)"scmc-invp-form", (Object[])new Object[0]));
                continue;
            }
            List<Map<String, String>> dimensionEntry = dimensionMap.get(dimension.getPkValue());
            this.checkBaseDataPerm(dimensionEntry, orgNumber, dataEntity);
            this.checkDimensionMatching(dimensionEntry, dataEntity);
        }
    }

    private void cacheBaseDataId(DynamicObject entity, DynamicObject org, Object dimensionPk, Map<Object, List<Map<String, String>>> dimensionMap, Map<Object, List<Long>> orgToBaseDataIdMap) {
        List<Map<String, String>> dimensionFieldToNameMap = dimensionMap.get(dimensionPk);
        Object orgPk = org.getPkValue();
        for (Map<String, String> map : dimensionFieldToNameMap) {
            String entityNumber = map.get("entityNumber");
            if ("bd_material".equals(entityNumber)) {
                this.getBaseDataId(entity, orgPk, "bd_material", orgToBaseDataIdMap);
                continue;
            }
            if (!"bd_warehouse".equals(entityNumber)) continue;
            this.getBaseDataId(entity, orgPk, "bd_warehouse", orgToBaseDataIdMap);
        }
    }

    private void getBaseDataId(DynamicObject entity, Object orgPk, String entityNumber, Map<Object, List<Long>> orgToBaseDataIdMap) {
        DynamicObject baseData = entity.getDynamicObject(entityNumber);
        if (baseData == null) {
            return;
        }
        List baseDataIds = orgToBaseDataIdMap.computeIfAbsent(orgPk, key -> new ArrayList());
        baseDataIds.add((Long)baseData.getPkValue());
    }

    private void cacheHasPermBaseData(String entityNumber, Map<Object, List<Long>> orgToBaseDataIdMap, Map<Object, List<Long>> orgToHasPermDataMap) {
        for (Map.Entry<Object, List<Long>> entry : orgToBaseDataIdMap.entrySet()) {
            Object orgPk = entry.getKey();
            List<Long> ids = entry.getValue();
            if (orgPk == null || ids == null || ids.isEmpty()) continue;
            if (orgToHasPermDataMap.get(orgPk) != null) {
                return;
            }
            String baseDataFilterCacheKey = entityNumber + orgPk;
            QFilter filter = new QFilter("id", "in", ids);
            QFilter baseFilter = this.baseFilterMap.get(baseDataFilterCacheKey);
            if (baseFilter == null && (baseFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityNumber, (Long)((Long)orgPk))) != null) {
                filter = filter.and(baseFilter);
                this.baseFilterMap.put(baseDataFilterCacheKey, baseFilter);
            }
            Map<Object, DynamicObject> hasPermBaseData = this.getBaseData(filter, entityNumber, "id");
            ArrayList<Long> hasPermDataIds = new ArrayList<Long>(hasPermBaseData.size());
            for (DynamicObject value : hasPermBaseData.values()) {
                hasPermDataIds.add((Long)value.getPkValue());
            }
            orgToHasPermDataMap.put(orgPk, hasPermDataIds);
        }
    }

    private void cacheMaterialGroup(DynamicObject entity, Map<Object, List<Map<String, String>>> dimensionMap) {
        Object org = entity.get("bos_org");
        DynamicObject dimension = entity.getDynamicObject("dimension");
        if (org == null || dimension == null) {
            return;
        }
        Object orgPk = ((DynamicObject)org).getPkValue();
        List<Map<String, String>> dimensionFieldToNameMap = dimensionMap.get(dimension.getPkValue());
        for (Map<String, String> map : dimensionFieldToNameMap) {
            QFilter fs;
            String entityNumber = map.get("entityNumber");
            if (!"bd_materialgroup".equals(entityNumber)) continue;
            String baseDataFilterCacheKey = entityNumber + orgPk;
            if (this.orgToHasPermMaterialGrpMap.get(orgPk) != null || (fs = this.baseFilterMap.get(baseDataFilterCacheKey)) != null) continue;
            fs = this.getGroupFilter(orgPk);
            if (fs != null) {
                this.baseFilterMap.put(baseDataFilterCacheKey, fs);
            }
            if (fs == null) {
                return;
            }
            Map<Object, DynamicObject> hasPermBaseData = this.getBaseData(fs, entityNumber, "id");
            ArrayList<Long> hasPermDataIds = new ArrayList<Long>(hasPermBaseData.size());
            for (DynamicObject value : hasPermBaseData.values()) {
                hasPermDataIds.add((Long)value.getPkValue());
            }
            this.orgToHasPermMaterialGrpMap.put(orgPk, hasPermDataIds);
        }
    }

    private QFilter getGroupFilter(Object orgPk) {
        if (orgPk == null) {
            return null;
        }
        return (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", Collections.singletonList((Long)orgPk), null, Boolean.FALSE});
    }

    private Map<Object, DynamicObject> getBaseData(QFilter filter, String entityNumber, String selectFields) {
        return BusinessDataServiceHelper.loadFromCache((String)entityNumber, (String)selectFields, (QFilter[])filter.toArray());
    }

    private void cacheDimension(DynamicObject entity, Map<Object, List<Map<String, String>>> dimensionMap) {
        DynamicObject dimension = entity.getDynamicObject("dimension");
        if (dimension == null) {
            return;
        }
        Object pkValue = dimension.getPkValue();
        if (dimensionMap.get(pkValue) != null) {
            return;
        }
        DynamicObject fullDimension = BusinessDataServiceHelper.loadSingleFromCache((Object)dimension.getPkValue(), (String)"msplan_plan_dimension", (String)"entryentity.dimensionname,entryentity.associationobject");
        DynamicObjectCollection entries = fullDimension.getDynamicObjectCollection("entryentity");
        ArrayList dimensionEntry = new ArrayList(entries.size());
        for (DynamicObject entry : entries) {
            HashMap<String, String> dimensionDetail = new HashMap<String, String>(entries.size());
            dimensionDetail.put("entityNumber", entry.getDynamicObject("associationobject").getString("number"));
            dimensionDetail.put("fieldName", entry.getString("dimensionname"));
            dimensionEntry.add(dimensionDetail);
        }
        dimensionMap.put(pkValue, dimensionEntry);
    }

    private void checkBaseDataPerm(List<Map<String, String>> dimensionEntry, String orgNumber, ExtendedDataEntity dataEntity) {
        for (Map<String, String> dimensionDetail : dimensionEntry) {
            String entityNumber = dimensionDetail.get("entityNumber");
            String fieldName = dimensionDetail.get("fieldName");
            switch (entityNumber) {
                case "bd_material": {
                    this.checkPermByDimension(dataEntity, this.orgToHasPermMaterialMap, orgNumber, entityNumber, fieldName);
                    break;
                }
                case "bd_materialgroup": {
                    this.checkPermByDimension(dataEntity, this.orgToHasPermMaterialGrpMap, orgNumber, entityNumber, fieldName);
                    break;
                }
                case "bd_warehouse": {
                    this.checkPermByDimension(dataEntity, this.orgToHasPermWarehouseMap, orgNumber, entityNumber, fieldName);
                    break;
                }
            }
        }
    }

    private void checkDimensionMatching(List<Map<String, String>> dimensionEntry, ExtendedDataEntity dataEntity) {
        DynamicObject entity = dataEntity.getDataEntity();
        List<String> fields = Arrays.asList("bd_material", "bd_warehouse", "bd_materialgroup");
        for (String field : fields) {
            Object fieldValue = entity.get(field);
            if (fieldValue == null) continue;
            boolean flag = false;
            for (Map<String, String> dimensionDetail : dimensionEntry) {
                String entityNumber = dimensionDetail.get("entityNumber");
                if (!field.equals(entityNumber)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            String fieldLocaleName = ((DynamicObject)fieldValue).getDataEntityType().getDisplayName().getLocaleValue();
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u4e0e\u7ef4\u5ea6\u9879\u201c{0}\u201d\u4e0d\u5339\u914d\u3002\n", (String)"InvpSafeStockRecSaveValidator_4", (String)"scmc-invp-form", (Object[])new Object[]{fieldLocaleName}));
        }
    }

    private void checkPermByDimension(ExtendedDataEntity dataEntity, Map<Object, List<Long>> hasPermMap, String orgNumber, String entityNumber, String fieldName) {
        DynamicObject entity = dataEntity.getDataEntity();
        DynamicObject fieldValue = entity.getDynamicObject(entityNumber);
        LocaleString fieldNameLocale = new LocaleString(fieldName);
        DynamicObject org = entity.getDynamicObject("bos_org");
        if (fieldValue == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c{0}\u201d\u3002\n", (String)"InvpSafeStockRecSaveValidator_1", (String)"scmc-invp-form", (Object[])new Object[]{fieldNameLocale}));
        } else {
            List<Long> hasPermDataIds = hasPermMap.get(org.getPkValue());
            if (hasPermDataIds != null && !hasPermDataIds.contains((Long)fieldValue.getPkValue())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c{0}\u201d\u7684\u4e1a\u52a1\u7ec4\u7ec7\u6ca1\u6709\u7f16\u7801\u4e3a\u201c{1}\u201d\u7684{2}\u7684\u4f7f\u7528\u6743\u9650\u3002\n", (String)"InvpSafeStockRecSaveValidator_2", (String)"scmc-invp-form", (Object[])new Object[]{orgNumber, fieldValue.getString("number"), fieldNameLocale}));
            }
        }
    }
}

