/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class InvpSchemeSaveValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Long> planOrgs = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            HashMap<String, String> signToNameMapping = new HashMap<String, String>(this.dataEntities.length);
            HashSet<String> noticedFields = new HashSet<String>(this.dataEntities.length);
            this.checkDemAndSupEntry(dataEntity, planOrgs);
            this.checkMustInput(dataEntity);
            this.checkDemDateMustInput(dataEntity);
            this.getFieldMapping(dataEntity, signToNameMapping);
            this.checkPriorityFieldRef(dataEntity, signToNameMapping, noticedFields);
            this.checkSupToDemMappingRef(dataEntity);
        }
    }

    private void checkSupToDemMappingRef(ExtendedDataEntity dataEntity) {
        HashMap<String, String> demandSignToNameMapping = new HashMap<String, String>(this.dataEntities.length);
        HashMap<String, String> supplySignToNameMapping = new HashMap<String, String>(this.dataEntities.length);
        DynamicObject entity = dataEntity.getDataEntity();
        DynamicObject mappingDimen = entity.getDynamicObject("suptodemmapping");
        DynamicObject targetObj = mappingDimen.getDynamicObject("tgtentity");
        DynamicObject sourceObj = mappingDimen.getDynamicObject("srcentity");
        DynamicObjectCollection matchEntry = mappingDimen.getDynamicObjectCollection("matchentry");
        for (DynamicObject entry : matchEntry) {
            if (targetObj.getString("number").equals("invp_demand_model")) {
                demandSignToNameMapping.put(entry.getString("tgtmatchfieldkey"), entry.getString("tgtmatchfield"));
            } else if (targetObj.getString("number").equals("invp_supply_model")) {
                supplySignToNameMapping.put(entry.getString("tgtmatchfieldkey"), entry.getString("tgtmatchfield"));
            }
            if (sourceObj.getString("number").equals("invp_demand_model")) {
                demandSignToNameMapping.put(entry.getString("srcmatchfieldkey"), entry.getString("srcmatchfield"));
                continue;
            }
            if (!sourceObj.getString("number").equals("invp_supply_model")) continue;
            supplySignToNameMapping.put(entry.getString("srcmatchfieldkey"), entry.getString("srcmatchfield"));
        }
        String demandTip = targetObj.getString("number").equals("invp_demand_model") ? ResManager.loadKDString((String)"\u9700\u6c42\u53c2\u6570\u7684\u4f9b\u9700\u5339\u914d\u7ef4\u5ea6\uff0c\u76ee\u6807\u5b9e\u4f53\u201c\u5e93\u5b58\u8ba1\u5212\u9700\u6c42\u6a21\u578b\u201d\u7684\u5b57\u6bb5\u201c%1$s\u201d\u5728\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u8d44\u6e90\u6ce8\u518c\u6a21\u578b\u5b57\u6bb5\u6620\u5c04\u4e2d\u4e3a\u5fc5\u987b\u6620\u5c04\u7684\u5b57\u6bb5\u3002", (String)"InvpSchemeSaveValidator_11", (String)"scmc-invp-form", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u9700\u6c42\u53c2\u6570\u7684\u4f9b\u9700\u5339\u914d\u7ef4\u5ea6\uff0c\u6765\u6e90\u5b9e\u4f53\u201c\u5e93\u5b58\u8ba1\u5212\u9700\u6c42\u6a21\u578b\u201d\u7684\u5b57\u6bb5\u201c%1$s\u201d\u5728\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u8d44\u6e90\u6ce8\u518c\u6a21\u578b\u5b57\u6bb5\u6620\u5c04\u4e2d\u4e3a\u5fc5\u987b\u6620\u5c04\u7684\u5b57\u6bb5\u3002", (String)"InvpSchemeSaveValidator_12", (String)"scmc-invp-form", (Object[])new Object[0]);
        String supplyTip = sourceObj.getString("number").equals("invp_supply_model") ? ResManager.loadKDString((String)"\u9700\u6c42\u53c2\u6570\u7684\u4f9b\u9700\u5339\u914d\u7ef4\u5ea6\uff0c\u6765\u6e90\u5b9e\u4f53\u201c\u5e93\u5b58\u8ba1\u5212\u4f9b\u5e94\u6a21\u578b\u201d\u7684\u5b57\u6bb5\u201c%1$s\u201d\u5728\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u8d44\u6e90\u6ce8\u518c\u5b57\u6bb5\u6620\u5c04\u4e2d\u4e3a\u5fc5\u987b\u6620\u5c04\u7684\u5b57\u6bb5\u3002", (String)"InvpSchemeSaveValidator_13", (String)"scmc-invp-form", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u9700\u6c42\u53c2\u6570\u7684\u4f9b\u9700\u5339\u914d\u7ef4\u5ea6\uff0c\u76ee\u6807\u5b9e\u4f53\u201d\u5e93\u5b58\u8ba1\u5212\u4f9b\u5e94\u6a21\u578b\u201c\u7684\u5b57\u6bb5\u201c%1$s\u201d\u5728\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u8d44\u6e90\u6ce8\u518c\u5b57\u6bb5\u6620\u5c04\u4e2d\u4e3a\u5fc5\u987b\u6620\u5c04\u7684\u5b57\u6bb5\u3002", (String)"InvpSchemeSaveValidator_14", (String)"scmc-invp-form", (Object[])new Object[0]);
        this.checkFieldMapping(dataEntity, demandSignToNameMapping, new HashSet<String>(1), "demandmodel", demandTip, true);
        this.checkFieldMapping(dataEntity, supplySignToNameMapping, new HashSet<String>(1), "supplymodel", supplyTip, true);
    }

    private void checkPriorityFieldRef(ExtendedDataEntity dataEntity, Map<String, String> signToNameMapping, Set<String> noticedFields) {
        String tipMsg = ResManager.loadKDString((String)"\u9700\u6c42\u4f18\u5148\u7ea7\u5206\u5f55\u7684\u5b57\u6bb5\u201c%1$s\u201d\uff0c\u5728\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u8d44\u6e90\u6ce8\u518c\u6a21\u578b\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u4e2d\u4e3a\u5fc5\u987b\u6620\u5c04\u7684\u5b57\u6bb5\u3002", (String)"InvpSchemeSaveValidator_10", (String)"scmc-invp-form", (Object[])new Object[0]);
        this.checkFieldMapping(dataEntity, signToNameMapping, noticedFields, "demandmodel", tipMsg, true);
    }

    private void checkFieldMapping(ExtendedDataEntity dataEntity, Map<String, String> signToNameMapping, Set<String> noticedFields, String modelFieldKey, String tipMsg, boolean nameFirst) {
        DynamicObject entity = dataEntity.getDataEntity();
        DynamicObject demandModel = entity.getDynamicObject(modelFieldKey);
        DynamicObjectCollection dataSrcCfg = demandModel.getDynamicObjectCollection("entryentityds");
        if (dataSrcCfg.isEmpty()) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u8d44\u6e90\u6ce8\u518c\u6a21\u578b\uff0c\u201c\u6570\u636e\u6e90\u914d\u7f6e\u201d\u4e3a\u5fc5\u5f55\u3002", (String)"InvpSchemeSaveValidator_8", (String)"scmc-invp-form", (Object[])new Object[0]), demandModel.getString("number")));
            return;
        }
        for (int i = 0; i < dataSrcCfg.size(); ++i) {
            DynamicObject dsEntry = (DynamicObject)dataSrcCfg.get(i);
            if (dsEntry.get("billfieldmap") == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u8d44\u6e90\u6ce8\u518c\u6a21\u578b\uff0c\u201c\u6570\u636e\u6e90\u914d\u7f6e\u201d\u7b2c%2$s\u884c\u201c\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u7f16\u7801\u201d\u4e3a\u5fc5\u5f55\u3002", (String)"InvpSchemeSaveValidator_9", (String)"scmc-invp-form", (Object[])new Object[0]), demandModel.getString("number"), i + 1));
                continue;
            }
            DynamicObject srcBillDs = dsEntry.getDynamicObject("srcbillds");
            if ("invp_invlevel".equals(srcBillDs.getString("number"))) continue;
            DynamicObject fieldMap = dsEntry.getDynamicObject("billfieldmap");
            DynamicObjectCollection colsMap = (fieldMap = BusinessDataServiceHelper.loadSingle((Object)fieldMap.getPkValue(), (String)"sbs_billfieldmapping")).getDynamicObjectCollection("colsmap");
            if (colsMap.isEmpty()) {
                for (Map.Entry<String, String> fieldEntry : signToNameMapping.entrySet()) {
                    String fieldKey = fieldEntry.getKey();
                    if (!noticedFields.add(fieldKey)) continue;
                    String fieldName = fieldEntry.getValue();
                    this.addErrorMessage(dataEntity, String.format(tipMsg, demandModel.getString("number"), fieldName));
                }
                continue;
            }
            HashSet<String> signSet = new HashSet<String>(colsMap.size());
            for (DynamicObject map : colsMap) {
                signSet.add(map.getString("targetobjcol"));
            }
            for (Map.Entry<String, String> fieldEntry : signToNameMapping.entrySet()) {
                String fieldKey = fieldEntry.getKey();
                String fieldName = fieldEntry.getValue();
                if (signSet.contains(fieldKey) || noticedFields.contains(fieldKey)) continue;
                if (nameFirst) {
                    this.addErrorMessage(dataEntity, String.format(tipMsg, fieldName, demandModel.getString("number")));
                } else {
                    this.addErrorMessage(dataEntity, String.format(tipMsg, demandModel.getString("number"), fieldName));
                }
                noticedFields.add(fieldKey);
            }
        }
    }

    private void getFieldMapping(ExtendedDataEntity dataEntity, Map<String, String> signToNameMapping) {
        DynamicObject entity = dataEntity.getDataEntity();
        DynamicObjectCollection priorityFieldMapping = entity.getDynamicObjectCollection("demprientry");
        for (DynamicObject mapping : priorityFieldMapping) {
            String logo = mapping.getString("demcolsign");
            String name = mapping.getString("demcolname");
            if (StringUtils.isEmpty((CharSequence)logo) || StringUtils.isEmpty((CharSequence)name)) continue;
            signToNameMapping.put(logo, name);
        }
    }

    private void checkDemDateMustInput(ExtendedDataEntity dataEntity) {
        DynamicObject entity = dataEntity.getDataEntity();
        DynamicObjectCollection priorityEntry = entity.getDynamicObjectCollection("demprientry");
        boolean flag = false;
        for (DynamicObject entry : priorityEntry) {
            String colSign = entry.getString("demcolsign");
            if (!"demanddate".equals(colSign)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9700\u6c42\u4f18\u5148\u7ea7\u5206\u5f55\uff0c\u9700\u6c42\u65e5\u671f\u4e3a\u5fc5\u987b\u914d\u7f6e\u7684\u5b57\u6bb5\u3002", (String)"InvpSchemeSaveValidator_7", (String)"scmc-invp-form", (Object[])new Object[0]));
        }
    }

    private void checkMustInput(ExtendedDataEntity dataEntity) {
        DynamicObject entity = dataEntity.getDataEntity();
        DynamicObjectCollection collection = entity.getDynamicObjectCollection("outputparamentry");
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject entry = (DynamicObject)collection.get(i);
            if (!entry.getBoolean("autoput")) continue;
            Object targetBill = entry.get("targetputbill");
            Object botp = entry.get("autoputbotp");
            if (targetBill != null && botp != null) continue;
            String tip = String.format(ResManager.loadKDString((String)"\u6295\u653e\u53c2\u6570\u7b2c%s\u884c\uff0c\u81ea\u52a8\u6295\u653e\u4e3a\u662f\u65f6\uff0c", (String)"InvpSchemeSaveValidator_2", (String)"scmc-invp-form", (Object[])new Object[0]), i + 1);
            if (targetBill == null) {
                String tip1 = ResManager.loadKDString((String)"\u201c\u6295\u653e\u751f\u6210\u76ee\u6807\u5355\u201d", (String)"InvpSchemeSaveValidator_3", (String)"scmc-invp-form", (Object[])new Object[0]);
                tip = tip + tip1;
            }
            if (botp == null) {
                if (targetBill == null) {
                    String tip2 = ResManager.loadKDString((String)"\u3001", (String)"InvpSchemeSaveValidator_6", (String)"scmc-invp-form", (Object[])new Object[0]);
                    tip = tip + tip2;
                }
                String tip3 = ResManager.loadKDString((String)"\u201cBOTP\u89c4\u5219\u201d", (String)"InvpSchemeSaveValidator_4", (String)"scmc-invp-form", (Object[])new Object[0]);
                tip = tip + tip3;
            }
            String tip4 = ResManager.loadKDString((String)"\u4e3a\u5fc5\u586b\u3002", (String)"InvpSchemeSaveValidator_5", (String)"scmc-invp-form", (Object[])new Object[0]);
            tip = tip + tip4;
            this.addErrorMessage(dataEntity, tip);
        }
    }

    private void checkDemAndSupEntry(ExtendedDataEntity dataEntity, Set<Long> planOrgs) {
        DynamicObject entity = dataEntity.getDataEntity();
        DynamicObject planOrg = entity.getDynamicObject("createorg");
        if (planOrg == null) {
            return;
        }
        planOrgs.add(planOrg.getLong("id"));
        if (!this.checkData(dataEntity, "demandparamentry", "indemcal")) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9700\u6c42\u53c2\u6570\u5206\u5f55\uff0c\u5fc5\u987b\u6709\u4e00\u884c\u7684 \u201c\u53c2\u4e0e\u8fd0\u7b97\u201d\u4e3a\u662f\u3002", (String)"InvpSchemeSaveValidator_0", (String)"scmc-invp-form", (Object[])new Object[0]));
        }
        if (!this.checkData(dataEntity, "supparamentry", "insupcal")) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4f9b\u5e94\u53c2\u6570\u5206\u5f55\uff0c\u5fc5\u987b\u6709\u4e00\u884c\u7684 \u201c\u53c2\u4e0e\u8fd0\u7b97\u201d\u4e3a\u662f\u3002", (String)"InvpSchemeSaveValidator_1", (String)"scmc-invp-form", (Object[])new Object[0]));
        }
    }

    private boolean checkData(ExtendedDataEntity dataEntity, String entityKey, String inCalKey) {
        DynamicObject bill = dataEntity.getDataEntity();
        DynamicObjectCollection entries = bill.getDynamicObjectCollection(entityKey);
        if (entries.isEmpty()) {
            return false;
        }
        boolean flag = false;
        for (DynamicObject entry : entries) {
            if (!entry.getBoolean(inCalKey)) continue;
            flag = true;
            break;
        }
        return flag;
    }
}

