/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.isf.business;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class ComplementBaseDataHelper {
    public static DynamicObject getMaterialSaleInfoByMaterialId(Long materialId) {
        if (materialId == null) {
            return null;
        }
        QFilter qFilter = new QFilter("masterid", "=", (Object)materialId);
        DynamicObject materialSaleInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialsalinfo", (QFilter[])new QFilter[]{qFilter});
        return materialSaleInfo;
    }

    public static DynamicObject getUnitById(Long unitId) {
        DynamicObject unit = BusinessDataServiceHelper.loadSingleFromCache((Object)unitId, (String)"bd_measureunits");
        return unit;
    }

    public static BigDecimal getDesQtyConv(DynamicObject materialId, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        if (materialId != null && srcUnit != null && desUnit != null && srcQty != null && srcQty.compareTo(BigDecimal.ZERO) != 0) {
            if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
                return srcQty;
            }
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)materialId.getPkValue()), (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null && muConv.getInt("denominator") != 0) {
                int precision = desUnit.getInt("precision");
                return srcQty.multiply(new BigDecimal(muConv.getInt("numerator"))).divide(new BigDecimal(muConv.getInt("denominator")), precision, ComplementBaseDataHelper.getRoundMode(desUnit));
            }
        }
        return BigDecimal.ZERO;
    }

    public static int getRoundMode(DynamicObject unit) {
        if (unit == null) {
            return 4;
        }
        String precisionAccount = unit.getString("precisionaccount");
        int baseUnitPrecisionType = 4;
        if ("2".equals(precisionAccount)) {
            baseUnitPrecisionType = 1;
        } else if ("3".equals(precisionAccount)) {
            baseUnitPrecisionType = 0;
        }
        return baseUnitPrecisionType;
    }
}

