/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.isf.common.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.exception.KDBizException;
import kd.scmc.isf.common.utils.DateUtils;

public class SaleForecastUtils {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String ONE_WEEK = "fweek";
    private static final String ONE_MONTH = "fmonth";

    public static String getPreTimeCycle(String preTimeType, Date preDate) {
        Date endDate;
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        switch (preTimeType) {
            case "fweek": {
                endDate = DateUtils.getEndDateByStartDate(preDate);
                break;
            }
            case "fmonth": {
                endDate = DateUtils.getLastDayOfCurrentMonth(preDate);
                break;
            }
            default: {
                throw new KDBizException("\u9519\u8bef\u7684\u9884\u6d4b\u65f6\u95f4\u7c7b\u578b");
            }
        }
        String preTime = format.format(preDate);
        return preTime + "~" + format.format(endDate);
    }

    private SaleForecastUtils() {
    }
}

