/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.isf.plugin.event;

import com.alibaba.fastjson.JSON;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.isf.common.enums.EnableEnum;
import kd.scmc.isf.common.enums.StatusEnum;
import kd.scmc.isf.plugin.event.ForecastEventSourceParams;
import kd.scmc.isf.plugin.event.ForecastEventSourceResult;
import kd.scmc.isf.service.mservice.impl.GenerationBillServiceImpl;

public class SaleForecastBillPlugin
implements IEventServicePlugin {
    private static final Log LOG = LogFactory.getLog(SaleForecastBillPlugin.class);
    private static final String SUCCESS_STATUS = "success";

    public Object handleEvent(KDBizEvent evt) {
        LOG.info("SaleForecastBillPlugin evt:{}", (Object)JSON.toJSONString((Object)evt));
        Long eventId = evt.getEventId();
        String eventNumber = evt.getEventNumber();
        String source = evt.getSource();
        ForecastEventSourceResult eventSourceResult = (ForecastEventSourceResult)JSON.parseArray((String)source, ForecastEventSourceResult.class).get(0);
        ForecastEventSourceParams params = eventSourceResult.getParams();
        LOG.info("params:{}", (Object)JSON.toJSONString((Object)params));
        String execStatus = params.getExecstatus();
        if (!SUCCESS_STATUS.equals(execStatus)) {
            LOG.warn(execStatus);
            return null;
        }
        this.generateResult(params);
        return eventId;
    }

    private void generateResult(ForecastEventSourceParams params) {
        String modelTypeId = params.getModeltypeid();
        QFilter forecastScheme = new QFilter("forecastscheme.number", "=", (Object)modelTypeId);
        QFilter autoDraw = new QFilter("isautodraw", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter enable = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        DynamicObject billCreateScheme = BusinessDataServiceHelper.loadSingleFromCache((String)"isf_billcreatescheme", (QFilter[])new QFilter[]{forecastScheme, autoDraw, status, enable});
        if (billCreateScheme == null) {
            LOG.info("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ed3\u679c\u5e94\u7528\u7b56\u7565");
            return;
        }
        GenerationBillServiceImpl generationBillService = new GenerationBillServiceImpl();
        generationBillService.generateBillByBillCreateScheme(billCreateScheme);
    }
}

