/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.isf.plugin.form.configscheme;

import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.isf.common.enums.GroupEnum;

public class DrawBillCreateScheme
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"groupfield", "drawbillfield", "forecastresultfield"});
    }

    public void beforeBindData(EventObject e) {
        this.initFilterGrid();
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        this.loadFilterCondition();
        super.afterBindData(e);
    }

    public void click(EventObject evt) {
        String fieldKey;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (fieldKey = control.getKey()) {
            case "groupfield": {
                this.showGroupTree();
                break;
            }
            case "drawbillfield": {
                DynamicObject bill = (DynamicObject)this.getModel().getValue("drawbill");
                if (bill == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e0b\u6e38\u5355\u636e\u3002", (String)"DrawBillCreateScheme_0", (String)"scmc-isf-form", (Object[])new Object[0]));
                    return;
                }
                String number = bill.getString("number");
                this.showBillTree("drawbillfield", number);
                break;
            }
            case "forecastresultfield": {
                this.showBillTree("forecastresultfield", "isf_saleforecast_result");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int row = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "drawbillfield": {
                if (newValue != null && newValue != "") break;
                this.getModel().setValue("drawbillfieldkey", null, row);
                this.getModel().setValue("drawbillfieldparent", null, row);
                break;
            }
            case "groupfield": {
                if (newValue != null && newValue != "") break;
                this.getModel().setValue("groupfieldkey", null, row);
                break;
            }
            case "drawbill": {
                if (newValue != null && newValue != "") break;
                this.getModel().deleteEntryData("drawtypeentry");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringUtils.isEmpty((CharSequence)actionId) || returnData == null) {
            return;
        }
        String fieldKey = returnData.toString();
        switch (actionId) {
            case "drawbillfield": {
                DynamicObject drawBill = (DynamicObject)this.getModel().getValue("drawbill");
                String billNumber = drawBill.getString("number");
                MainEntityType srcBillMainType = MetadataServiceHelper.getDataEntityType((String)billNumber);
                IDataEntityProperty findProperty = srcBillMainType.findProperty(fieldKey);
                if (findProperty == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u4e0d\u5b58\u5728\u8be5\u5b57\u6bb5\u3002", (String)"DrawBillCreateScheme_2", (String)"scmc-isf-form", (Object[])new Object[0]));
                    return;
                }
                LocaleString displayCaption = findProperty.getDisplayName();
                String fieldName = displayCaption.getLocaleValue();
                String fieldParentName = findProperty.getParent().getName();
                if (fieldParentName.equals(billNumber)) {
                    fieldParentName = null;
                }
                int row = this.getModel().getEntryCurrentRowIndex("fieldmappingentry");
                this.getModel().setValue("drawbillfield", (Object)fieldName, row);
                this.getModel().setValue("drawbillfieldkey", (Object)fieldKey, row);
                this.getModel().setValue("drawbillfieldparent", (Object)fieldParentName, row);
                break;
            }
            case "groupfield": {
                String groupFieldName = this.getFieldName(fieldKey);
                if (groupFieldName == null) {
                    return;
                }
                int groupRow = this.getModel().getEntryCurrentRowIndex("drawtypeentry");
                this.getModel().setValue("groupfield", (Object)groupFieldName, groupRow);
                this.getModel().setValue("groupfieldkey", (Object)fieldKey, groupRow);
                break;
            }
            case "forecastresultfield": {
                String resultFieldName = this.getFieldName(fieldKey);
                if (resultFieldName == null) {
                    return;
                }
                int resultRow = this.getModel().getEntryCurrentRowIndex("fieldmappingentry");
                this.getModel().setValue("forecastresultfield", (Object)resultFieldName, resultRow);
                this.getModel().setValue("forecastresultfieldkey", (Object)fieldKey, resultRow);
                break;
            }
        }
    }

    private String getFieldName(String fieldKey) {
        MainEntityType srcBillMainType = MetadataServiceHelper.getDataEntityType((String)"isf_saleforecast_result");
        IDataEntityProperty findProperty = srcBillMainType.findProperty(fieldKey);
        if (findProperty == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u539f\u59cb\u9884\u6d4b\u7ed3\u679c\u4e2d\u4e0d\u5b58\u5728\u8be5\u5b57\u6bb5\u3002", (String)"DrawBillCreateScheme_1", (String)"scmc-isf-form", (Object[])new Object[0]));
            return null;
        }
        LocaleString displayCaption = findProperty.getDisplayName();
        String fieldName = displayCaption.getLocaleValue();
        return fieldName;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate oprate = (FormOperate)args.getSource();
        String operationKey = oprate.getOperateKey();
        if ("save".equals(operationKey) || "submit".equals(operationKey)) {
            FilterCondition filterCondition = this.getFilter();
            this.saveFilterToText(filterCondition);
        }
        super.beforeDoOperation(args);
    }

    private void showBillTree(String callBackId, String number) {
        MainEntityType sourceEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setIncludePKField(false);
        option.setIncludeBDRefProp(false);
        TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceEntityType, (PropTreeBuildOption)option);
        this.showSrcFieldForm(treeNode, callBackId);
    }

    private void showGroupTree() {
        TreeNode treeNode = new TreeNode();
        treeNode.setId("isf_saleforecast_result");
        MainEntityType sourceEntityType = MetadataServiceHelper.getDataEntityType((String)"isf_saleforecast_result");
        treeNode.setText(sourceEntityType.getDisplayName().toString());
        treeNode.setIsOpened(true);
        for (GroupEnum groupField : GroupEnum.values()) {
            treeNode.addChild(this.buildChildNode(groupField.getValue(), groupField.getName()));
        }
        this.showSrcFieldForm(treeNode, "groupfield");
    }

    private TreeNode buildChildNode(String id, String text) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId(id);
        treeNode.setText(text);
        return treeNode;
    }

    private void showSrcFieldForm(TreeNode treeNode, String callBackId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)treeNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void initFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"isf_saleforecast_result");
        filterGrid.setEntityNumber("isf_saleforecast_result");
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        List cols = entityTypeUtil.getFilterColumns((IDataEntityType)dataEntityType);
        filterGrid.setFilterColumns(cols);
        this.getView().updateView("filtergridap");
    }

    private FilterCondition getFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        return condition;
    }

    private void saveFilterToText(FilterCondition filterCondition) {
        String filter = null;
        if (filterCondition != null) {
            filter = SerializationUtils.toJsonString((Object)filterCondition);
        }
        this.getModel().setValue("datafilterrule", (Object)filter);
    }

    private void loadFilterCondition() {
        Object filterObj = this.getModel().getValue("datafilterrule");
        FilterCondition filterCondition = null;
        if (!StringUtils.isBlank((Object)filterObj)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterObj.toString(), FilterCondition.class);
        }
        if (filterCondition != null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            filterGrid.SetValue(filterCondition);
        }
    }
}

