/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.isf.plugin.form.configscheme;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DrawBillCreateSchemeListPlugin
extends AbstractListPlugin
implements BeforeFilterF7SelectListener {
    private static final String DRAW_BILL_COMMON_FILTER = "drawbill.id";
    private static final String DRAW_BILL_NUMBER = "isf_saleforecastbill";
    private static final String F7_ENTITY_NAME = "bos_entityobject";
    private static final String DRAW_BILL_COMMON_FILTER_NAME = "drawbill.name";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        List<ComboItem> comboItems = this.buildDrawBillFilterComboItems();
        commonFilterColumns.forEach(filterColumn -> {
            String fieldName = filterColumn.getFieldName();
            if (DRAW_BILL_COMMON_FILTER_NAME.equals(fieldName)) {
                ((CommonFilterColumn)filterColumn).setComboItems(comboItems);
                return;
            }
        });
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent beforeFilterF7SelectEvent) {
        String fieldName = beforeFilterF7SelectEvent.getFieldName();
        if (DRAW_BILL_COMMON_FILTER.equals(fieldName)) {
            QFilter drawBillFilter = new QFilter("number", "=", (Object)DRAW_BILL_NUMBER);
            beforeFilterF7SelectEvent.addCustomQFilter(drawBillFilter);
        }
    }

    private List<ComboItem> buildDrawBillFilterComboItems() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        QFilter drawBillFilter = new QFilter("number", "=", (Object)DRAW_BILL_NUMBER);
        DynamicObject entityObject = BusinessDataServiceHelper.loadSingle((String)F7_ENTITY_NAME, (String)"id,number,name", (QFilter[])drawBillFilter.toArray());
        ComboItem comboItem = new ComboItem();
        comboItem.setId((String)entityObject.getPkValue());
        comboItem.setValue((String)entityObject.getPkValue());
        String caption = ((OrmLocaleValue)entityObject.get("name")).getLocaleValue();
        comboItem.setCaption(new LocaleString(caption));
        comboItems.add(comboItem);
        return comboItems;
    }
}

