/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.isf.plugin.form.saleforecast;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.scmc.isf.common.utils.DateUtils;

public class SaleForecastBillPlugin
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        int i;
        super.afterBindData(e);
        DynamicObject forecastScheme = (DynamicObject)this.getModel().getValue("forecastscheme");
        if (forecastScheme == null) {
            return;
        }
        String forecastCycle = forecastScheme.getString("forecastcycle");
        String forecastLength = forecastScheme.getString("forecastlength");
        int length = Integer.parseInt(forecastLength);
        String forecastValue = forecastScheme.getString("forecastvalue");
        List<String> allForecastCycle = this.getAllForecastCycle(length, forecastCycle);
        for (i = length + 1; i <= 12; ++i) {
            String ctlKey = "period" + i;
            this.getView().setVisible(Boolean.FALSE, new String[]{ctlKey});
        }
        if ("fqty".equals(forecastValue)) {
            for (i = 1; i <= length; ++i) {
                String oriPreAmountKey = "oripreamount" + i;
                String preAmountKey = "preamount" + i;
                this.getView().setVisible(Boolean.FALSE, new String[]{oriPreAmountKey, preAmountKey});
            }
        } else {
            for (i = 1; i <= length; ++i) {
                String oriPreQtyKey = "oripreqty" + i;
                String preQtyKey = "preqty" + i;
                this.getView().setVisible(Boolean.FALSE, new String[]{oriPreQtyKey, preQtyKey});
            }
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        for (int i2 = 1; i2 <= length; ++i2) {
            String ctlKey = "period" + i2;
            String title = allForecastCycle.get(i2 - 1);
            entryGrid.setColumnProperty(ctlKey, "header", (Object)new LocaleString(title));
        }
    }

    private List<String> getAllForecastCycle(int length, String forecastCycle) {
        ArrayList<String> list;
        block4: {
            Date forecastDate;
            block3: {
                forecastDate = (Date)this.getModel().getValue("pretime", 0);
                if (forecastDate == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u6570\u636e\u5f02\u5e38\uff0c\u9884\u6d4b\u65f6\u95f4\u4e3a\u7a7a\u3002", (String)"SaleForecastBillPlugin_0", (String)"scmc-isf-form", (Object[])new Object[0]));
                }
                list = new ArrayList<String>();
                if (!"fweek".equals(forecastCycle)) break block3;
                for (int i = 0; i < length; ++i) {
                    Date endDate = DateUtils.getEndDateByStartDate(forecastDate);
                    String startDateStr = DateUtils.getStringFromShortDate(forecastDate);
                    String endDateStr = DateUtils.getStringFromShortDate(endDate);
                    String titleStr = startDateStr + "~" + endDateStr;
                    list.add(titleStr);
                    forecastDate = DateUtils.getTomorrowByDate(endDate);
                }
                break block4;
            }
            if (!"fmonth".equals(forecastCycle)) break block4;
            for (int i = 0; i < length; ++i) {
                Date endDate = DateUtils.getLastDayOfCurrentMonth(forecastDate);
                String startDateStr = DateUtils.getStringFromShortDate(forecastDate);
                String endDateStr = DateUtils.getStringFromShortDate(endDate);
                String titleStr = startDateStr + "~" + endDateStr;
                list.add(titleStr);
                forecastDate = DateUtils.getFirstDayOfNextMonth(endDate);
            }
        }
        return list;
    }
}

