/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.isf.plugin.form.saleforecast;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.mvc.list.ListDataProvider;
import kd.scmc.isf.common.utils.SaleForecastUtils;

public class SaleForecastListDataProvider
extends ListDataProvider {
    private static final String PRE_TIME = "pretime";
    private static final String PRE_TIME_CYCLE = "pretimecycle";
    private static final String PRE_TIME_TYPE = "pretimetype";
    private static final String PRE_ORG_TYPE = "preorgtype";

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection rows = super.getData(start, limit);
        if (!rows.isEmpty()) {
            rows.forEach(row -> {
                this.setPreTimeCycle((DynamicObject)row);
                this.setPreOrgType((DynamicObject)row);
            });
        }
        return rows;
    }

    private void setPreTimeCycle(DynamicObject row) {
        Date preDate = (Date)row.get(PRE_TIME);
        String preTimeType = row.getString(PRE_TIME_TYPE);
        if (preDate == null || preTimeType == null) {
            return;
        }
        String preTimeCycle = SaleForecastUtils.getPreTimeCycle(preTimeType, preDate);
        row.set(PRE_TIME_CYCLE, (Object)preTimeCycle);
    }

    private void setPreOrgType(DynamicObject row) {
        String preOrgType = row.getString(PRE_ORG_TYPE);
        if (preOrgType == null || "".equals(preOrgType)) {
            row.set(PRE_ORG_TYPE, (Object)ResManager.loadKDString((String)"\u9500\u552e\u7ec4\u7ec7", (String)"SaleForecastListDataProvider_0", (String)"scmc-isf-form", (Object[])new Object[0]));
        }
    }
}

