/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.isf.plugin.op;

import java.util.Arrays;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.isf.common.pojo.ServiceResult;
import kd.scmc.isf.service.mservice.impl.GenerationBillServiceImpl;

public class BillGenerationPlugin
extends AbstractOperationServicePlugIn {
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject billCreateScheme = this.getBillCreateScheme(dataEntities);
        if (billCreateScheme == null) {
            return;
        }
        GenerationBillServiceImpl generationBillService = new GenerationBillServiceImpl();
        ServiceResult serviceResult = generationBillService.generateBillByBillCreateScheme(billCreateScheme);
        if (!serviceResult.isSuccess()) {
            this.operationResult.setSuccess(serviceResult.isSuccess());
            this.operationResult.setMessage(serviceResult.getMessage());
        }
    }

    private DynamicObject getBillCreateScheme(DynamicObject[] dataEntities) {
        Optional<DynamicObject> first = Arrays.stream(dataEntities).findFirst();
        if (first.isPresent()) {
            DynamicObject dynamicObject = first.get();
            DynamicObject billCreateScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)dynamicObject.getPkValue(), (String)"isf_billcreatescheme");
            return billCreateScheme;
        }
        return null;
    }
}

