/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.isf.service.mservice.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.isf.business.ComplementBaseDataHelper;
import kd.scmc.isf.common.enums.GroupEnum;
import kd.scmc.isf.common.enums.StatusEnum;
import kd.scmc.isf.common.pojo.FieldProperty;
import kd.scmc.isf.common.pojo.ForecastResultInfo;
import kd.scmc.isf.common.pojo.ServiceResult;
import kd.scmc.isf.common.utils.DateUtils;
import kd.scmc.isf.service.mservice.GenerationBillService;

public class GenerationBillServiceImpl
implements GenerationBillService {
    private static final Log LOG = LogFactory.getLog(GenerationBillServiceImpl.class);
    private static final String SELECT_FIELD = "id,org,warehouse,material,basiconegroup,basictwogroup,group,supplier,baseunit,customer,customgroup,pretime,prevalue,pretimetype,prevaluetype,modeltype,modeltypename,pretype,calfinishtime,isbotp";
    private static final String[] SELECT_FIELD_ARRAY = new String[]{"id", "org", "warehouse", "material", "basiconegroup", "basictwogroup", "group", "supplier", "baseunit", "customer", "customgroup", "pretime", "prevalue", "pretimetype", "prevaluetype", "modeltype", "modeltypename", "pretype", "calfinishtime", "isbotp"};

    @Override
    public ServiceResult generateBillByBillCreateScheme(DynamicObject billCreateScheme) {
        DynamicObject[] resultMap;
        ServiceResult serviceResult = new ServiceResult();
        if (billCreateScheme == null) {
            LOG.info("\u7ed3\u679c\u5e94\u7528\u7b56\u7565\u4e3a\u7a7a");
            serviceResult.setSuccess(Boolean.FALSE);
            serviceResult.setMessage(ResManager.loadKDString((String)"\u7ed3\u679c\u5e94\u7528\u7b56\u7565\u4e3a\u7a7a\u3002", (String)"GenerationBillServiceImpl_0", (String)"scmc-isf-form", (Object[])new Object[0]));
            return serviceResult;
        }
        DynamicObject forecastScheme = billCreateScheme.getDynamicObject("forecastscheme");
        if (forecastScheme == null) {
            LOG.info("\u7ed3\u679c\u5e94\u7528\u7b56\u7565\u4e2d\u9884\u6d4b\u65b9\u6848\u4e3a\u7a7a");
            serviceResult.setSuccess(Boolean.FALSE);
            serviceResult.setMessage(ResManager.loadKDString((String)"\u7ed3\u679c\u5e94\u7528\u7b56\u7565\u4e2d\u9884\u6d4b\u65b9\u6848\u4e3a\u7a7a\u3002", (String)"GenerationBillServiceImpl_1", (String)"scmc-isf-form", (Object[])new Object[0]));
            return serviceResult;
        }
        QFilter modelType = new QFilter("pretype", "=", (Object)forecastScheme.getString("pretype"));
        DynamicObjectCollection finishTimeDynamicObject = QueryServiceHelper.query((String)"isf_saleforecast_result", (String)SELECT_FIELD, (QFilter[])new QFilter[]{modelType}, (String)"calfinishtime desc", (int)1);
        if (finishTimeDynamicObject == null || finishTimeDynamicObject.isEmpty()) {
            LOG.info("\u672a\u627e\u5230\u6709\u6548\u7684\u8ba1\u7b97\u65f6\u95f4");
            serviceResult.setSuccess(Boolean.FALSE);
            serviceResult.setMessage(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6548\u7684\u8ba1\u7b97\u65f6\u95f4\u3002", (String)"GenerationBillServiceImpl_2", (String)"scmc-isf-form", (Object[])new Object[0]));
            return serviceResult;
        }
        Date finishTime = ((DynamicObject)finishTimeDynamicObject.get(0)).getDate("calfinishtime");
        QFilter finishTimeFilter = new QFilter("calfinishtime", "=", (Object)finishTime);
        QFilter generate = new QFilter("isbotp", "=", (Object)"0");
        DataSet forecastResultColl = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"isf_saleforecast_result", (String)SELECT_FIELD, (QFilter[])new QFilter[]{modelType, generate, finishTimeFilter}, null);
        List<String> groupByField = this.getGroupByField(forecastScheme);
        DataSet groupDimension = forecastResultColl.groupBy(groupByField.toArray(new String[0])).max("id").finish();
        DataSet resultByClean = forecastResultColl.join(groupDimension).on("id", "id").select(SELECT_FIELD_ARRAY).finish();
        DataSet resultOrderBy = resultByClean.orderBy(new String[]{"pretime"});
        QFilter filterByScheme = this.getFilterByScheme(billCreateScheme);
        DataSet resultByDateFilter = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"isf_saleforecast_result", (String)SELECT_FIELD, (QFilter[])new QFilter[]{modelType, filterByScheme}, (String)"pretime");
        DataSet mixedResult = resultOrderBy.join(resultByDateFilter).on("id", "id").select(SELECT_FIELD_ARRAY).finish();
        Map<String, DynamicObject> relationship = this.getRelationship(billCreateScheme);
        List<String> drawTypeList = this.getGroupAndPushKeyByScheme(billCreateScheme);
        List<ForecastResultInfo> forecastResultInfos = this.buildBillList(mixedResult, relationship);
        if (forecastResultInfos.isEmpty()) {
            LOG.info("\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u539f\u59cb\u9884\u6d4b\u7ed3\u679c");
            serviceResult.setSuccess(Boolean.FALSE);
            serviceResult.setMessage(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u539f\u59cb\u9884\u6d4b\u7ed3\u679c\u3002", (String)"GenerationBillServiceImpl_3", (String)"scmc-isf-form", (Object[])new Object[0]));
            return serviceResult;
        }
        Map<Object, List<ForecastResultInfo>> groupMap = this.groupBillListByRule(mixedResult, drawTypeList, forecastResultInfos);
        ArrayList<Long> idList = new ArrayList<Long>();
        DataSet copy = mixedResult.copy();
        for (DynamicObject[] row : copy) {
            Long id = row.getLong("id");
            idList.add(id);
        }
        for (DynamicObject result : resultMap = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"isf_saleforecast_result"))) {
            result.set("isbotp", (Object)"1");
        }
        mixedResult.close();
        List<DynamicObject> saleForecastBillList = this.generationBillByDataMap(billCreateScheme, groupMap, forecastScheme, relationship);
        this.setBillIdAndBillNumber(saleForecastBillList);
        SaveServiceHelper.save((DynamicObject[])saleForecastBillList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])resultMap);
        serviceResult.setSuccess(Boolean.TRUE);
        return serviceResult;
    }

    private List<DynamicObject> generationBillByDataMap(DynamicObject billCreateScheme, Map<Object, List<ForecastResultInfo>> groupMap, DynamicObject forecastScheme, Map<String, DynamicObject> relationship) {
        Map<String, String> headInfo = this.divideRelationship(relationship, null);
        Map<String, String> entryInfo = this.divideRelationship(relationship, "entryentity");
        DynamicObject drawBill = billCreateScheme.getDynamicObject("drawbill");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)drawBill.getString("number"));
        ArrayList<DynamicObject> saleForecastBillList = new ArrayList<DynamicObject>(groupMap.size());
        for (List<ForecastResultInfo> forecastResults : groupMap.values()) {
            Map<String, FieldProperty> info = forecastResults.get(0).getInfo();
            DynamicObject newSaleForecastBill = new DynamicObject((DynamicObjectType)dataEntityType);
            newSaleForecastBill.set("billstatus", (Object)StatusEnum.SAVE.getValue());
            newSaleForecastBill.set("creator", (Object)RequestContext.get().getCurrUserId());
            newSaleForecastBill.set("forecastscheme", (Object)forecastScheme);
            newSaleForecastBill.set("bizdate", (Object)DateUtils.getShortDateFromLongDate(new Date()));
            for (Map.Entry<String, String> entryRow : headInfo.entrySet()) {
                Map<String, Long> currencyAndExRateTable;
                newSaleForecastBill.set(entryRow.getValue(), info.get(entryRow.getKey()).getPropertyValue());
                if (!"org".equals(entryRow.getKey()) || (currencyAndExRateTable = this.getCurrencyAndExRateTable((Long)info.get(entryRow.getKey()).getPropertyValue())) == null || currencyAndExRateTable.isEmpty()) continue;
                newSaleForecastBill.set("currency", (Object)currencyAndExRateTable.get("baseCurrencyID"));
            }
            this.setEntryData(forecastResults, newSaleForecastBill, entryInfo, forecastScheme);
            saleForecastBillList.add(newSaleForecastBill);
        }
        return saleForecastBillList;
    }

    private Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        Map mapOrg;
        Map<String, Long> map = new HashMap<String, Long>(16);
        if (orgId != null && (mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)) != null && mapOrg.get("id") != null && (map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")))) != null && map.size() != 0) {
            return map;
        }
        return map;
    }

    private Set<Map<String, Long>> getEntryGroup(List<ForecastResultInfo> forecastResults) {
        LinkedHashSet<Map<String, Long>> set = new LinkedHashSet<Map<String, Long>>(16);
        if (forecastResults.isEmpty()) {
            return set;
        }
        for (ForecastResultInfo forecastResultInfo : forecastResults) {
            Map<String, FieldProperty> forecastResult = forecastResultInfo.getInfo();
            FieldProperty materialField = forecastResult.get("material");
            FieldProperty warehouseField = forecastResult.get("warehouse");
            Long material = (Long)materialField.getPropertyValue();
            Long warehouse = (Long)warehouseField.getPropertyValue();
            HashMap<String, Long> groupMap = new HashMap<String, Long>(2);
            groupMap.put("material", material);
            groupMap.put("warehouse", warehouse);
            set.add(groupMap);
        }
        return set;
    }

    private void setEntryData(List<ForecastResultInfo> forecastResults, DynamicObject newSaleForecastBill, Map<String, String> entryInfo, DynamicObject forecastScheme) {
        String preValueType = forecastScheme.getString("forecastvalue");
        Set<Map<String, Long>> entryGroup = this.getEntryGroup(forecastResults);
        DynamicObjectCollection entryEntity = newSaleForecastBill.getDynamicObjectCollection("entryentity");
        entryEntity.clear();
        ArrayList entryListColl = new ArrayList(entryGroup.size());
        for (Map<String, Long> map : entryGroup) {
            ArrayList<ForecastResultInfo> entryList = new ArrayList<ForecastResultInfo>();
            for (ForecastResultInfo forecastResultInfo : forecastResults) {
                Map<String, FieldProperty> forecastResult = forecastResultInfo.getInfo();
                FieldProperty materialField = forecastResult.get("material");
                FieldProperty warehouseField = forecastResult.get("warehouse");
                Long material = (Long)materialField.getPropertyValue();
                Long warehouse = (Long)warehouseField.getPropertyValue();
                if (material.compareTo(map.get("material")) != 0 || warehouse.compareTo(map.get("warehouse")) != 0) continue;
                entryList.add(forecastResultInfo);
            }
            entryListColl.add(entryList);
        }
        for (List list : entryListColl) {
            DynamicObject newEntryEntity = entryEntity.addNew();
            ForecastResultInfo firstEntry = (ForecastResultInfo)list.get(0);
            Map<String, FieldProperty> firstEntryInfo = firstEntry.getInfo();
            for (Map.Entry<String, String> entryRow : entryInfo.entrySet()) {
                if (entryRow.getKey().equals("material")) {
                    DynamicObject materialSaleInfo = ComplementBaseDataHelper.getMaterialSaleInfoByMaterialId((Long)firstEntryInfo.get("material").getPropertyValue());
                    if (materialSaleInfo == null) {
                        LOG.info("\u7269\u6599\u9500\u552e\u4fe1\u606f\u4e0d\u5b58\u5728");
                        return;
                    }
                    newEntryEntity.set(entryRow.getValue(), (Object)materialSaleInfo);
                    DynamicObject salesUnit = materialSaleInfo.getDynamicObject("salesunit");
                    newEntryEntity.set("unit", (Object)salesUnit);
                    continue;
                }
                newEntryEntity.set(entryRow.getValue(), firstEntryInfo.get(entryRow.getKey()).getPropertyValue());
            }
            if ("fqty".equals(preValueType)) {
                DynamicObject baseUnit = ComplementBaseDataHelper.getUnitById(newEntryEntity.getLong("baseunit"));
                DynamicObject unit = newEntryEntity.getDynamicObject("unit");
                DynamicObject material = newEntryEntity.getDynamicObject("material");
                DynamicObject masterId = material.getDynamicObject("masterid");
                for (int i = 1; i <= list.size(); ++i) {
                    ForecastResultInfo forecastResultInfo = (ForecastResultInfo)list.get(i - 1);
                    Map<String, FieldProperty> info = forecastResultInfo.getInfo();
                    String oriKey = "oripreqty" + i;
                    String preKey = "preqty" + i;
                    BigDecimal preValue = (BigDecimal)info.get("prevalue").getPropertyValue();
                    BigDecimal qty = ComplementBaseDataHelper.getDesQtyConv(masterId, baseUnit, preValue, unit);
                    newEntryEntity.set(oriKey, (Object)qty);
                    newEntryEntity.set(preKey, (Object)qty);
                }
                continue;
            }
            for (int i = 1; i <= list.size(); ++i) {
                ForecastResultInfo forecastResultInfo = (ForecastResultInfo)list.get(i - 1);
                Map<String, FieldProperty> info = forecastResultInfo.getInfo();
                String oriKey = "oripreamount" + i;
                String preKey = "preamount" + i;
                newEntryEntity.set(oriKey, info.get("prevalue").getPropertyValue());
                newEntryEntity.set(preKey, info.get("prevalue").getPropertyValue());
            }
        }
    }

    private Map<Object, List<ForecastResultInfo>> groupBillListByRule(DataSet mixedResult, List<String> drawTypeList, List<ForecastResultInfo> forecastResultInfos) {
        LinkedHashMap<Object, List<ForecastResultInfo>> groupMap = new LinkedHashMap<Object, List<ForecastResultInfo>>(16);
        if (drawTypeList.isEmpty()) {
            for (int i = 0; i < forecastResultInfos.size(); ++i) {
                ArrayList<ForecastResultInfo> list = new ArrayList<ForecastResultInfo>(1);
                list.add(forecastResultInfos.get(i));
                groupMap.put(i, list);
            }
        } else {
            DataSet copy2 = mixedResult.copy();
            DataSet groupRule = copy2.groupBy(drawTypeList.toArray(new String[0])).finish();
            for (Row row : groupRule) {
                List<ForecastResultInfo> resultInfoList = this.getResultInfoList(forecastResultInfos, row, drawTypeList);
                String groupKey = this.getGroupKey(row, drawTypeList);
                groupMap.put(groupKey, resultInfoList);
            }
        }
        return groupMap;
    }

    private List<ForecastResultInfo> buildBillList(DataSet mixedResult, Map<String, DynamicObject> relationship) {
        ArrayList<ForecastResultInfo> forecastResultInfos = new ArrayList<ForecastResultInfo>();
        DataSet copy1 = mixedResult.copy();
        for (Row row : copy1) {
            Map<String, FieldProperty> fieldProperties = this.buildPropertyColl(row, relationship);
            ForecastResultInfo forecastResultInfo = new ForecastResultInfo();
            forecastResultInfo.setInfo(fieldProperties);
            forecastResultInfos.add(forecastResultInfo);
        }
        return forecastResultInfos;
    }

    private List<String> getGroupAndPushKeyByScheme(DynamicObject billCreateScheme) {
        DynamicObjectCollection drawTypeEntry = billCreateScheme.getDynamicObjectCollection("drawtypeentry");
        ArrayList<String> drawTypeList = new ArrayList<String>(drawTypeEntry.size());
        if (drawTypeEntry.isEmpty()) {
            return drawTypeList;
        }
        for (DynamicObject entry : drawTypeEntry) {
            String groupFieldKey = entry.getString("groupfieldkey");
            drawTypeList.add(groupFieldKey);
        }
        return drawTypeList;
    }

    private Map<String, String> divideRelationship(Map<String, DynamicObject> relationship, String divideKey) {
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>(16);
        if (divideKey == null) {
            for (Map.Entry<String, DynamicObject> entryRow : relationship.entrySet()) {
                DynamicObject entry = entryRow.getValue();
                String fieldParent = entry.getString("drawbillfieldparent");
                if (fieldParent != null && !fieldParent.isEmpty()) continue;
                info.put(entry.getString("forecastresultfieldkey"), entry.getString("drawbillfieldkey"));
            }
        } else {
            for (Map.Entry<String, DynamicObject> entryRow : relationship.entrySet()) {
                DynamicObject entry = entryRow.getValue();
                String fieldParent = entry.getString("drawbillfieldparent");
                if (!fieldParent.equals(divideKey)) continue;
                info.put(entry.getString("forecastresultfieldkey"), entry.getString("drawbillfieldkey"));
            }
        }
        return info;
    }

    private QFilter getFilterByScheme(DynamicObject billCreateScheme) {
        String filterObj = billCreateScheme.getString("datafilterrule");
        FilterCondition filterCondition = null;
        if (!StringUtils.isBlank((CharSequence)filterObj)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterObj, FilterCondition.class);
        }
        FilterBuilder fb = new FilterBuilder(MetadataServiceHelper.getDataEntityType((String)"isf_saleforecast_result"), filterCondition);
        fb.buildFilter();
        QFilter dataFilter = fb.getQFilter();
        return dataFilter;
    }

    private List<String> getGroupByField(DynamicObject forecastScheme) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("warehouse");
        list.add("pretime");
        list.add(forecastScheme.getString("orgdimension"));
        list.add(forecastScheme.getString("productdimension"));
        String customerDimension = forecastScheme.getString("cusdimension");
        if (customerDimension != null && !customerDimension.isEmpty()) {
            list.add(customerDimension);
        }
        return list;
    }

    private void setBillIdAndBillNumber(List<DynamicObject> saleForecastBillList) {
        long[] billIds = DB.genLongIds((String)"isf_saleforecastbill", (int)saleForecastBillList.size());
        List billNumbers = CodeRuleServiceHelper.getNumbers((String)"isf_saleforecastbill", saleForecastBillList);
        for (int i = 0; i < saleForecastBillList.size(); ++i) {
            DynamicObject entity = saleForecastBillList.get(i);
            entity.set("id", (Object)billIds[i]);
            entity.set("billno", billNumbers.get(i));
        }
    }

    private String getGroupKey(Row row, List<String> drawTypeList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String drawType : drawTypeList) {
            Object value = row.get(drawType);
            stringBuilder.append(value);
        }
        return stringBuilder.toString();
    }

    private List<ForecastResultInfo> getResultInfoList(List<ForecastResultInfo> forecastResultInfos, Row row, List<String> drawTypeList) {
        ArrayList<ForecastResultInfo> resultInfoList = new ArrayList<ForecastResultInfo>();
        for (ForecastResultInfo result : forecastResultInfos) {
            boolean group = this.whetherInTheGroup(result, row, drawTypeList);
            if (!group) continue;
            resultInfoList.add(result);
        }
        return resultInfoList;
    }

    private boolean whetherInTheGroup(ForecastResultInfo result, Row row, List<String> drawTypeList) {
        Map<String, FieldProperty> billInfo = result.getInfo();
        boolean flag = Boolean.TRUE;
        for (String drawType : drawTypeList) {
            Comparable<Date> propertyValue;
            FieldProperty fieldProperty;
            if (drawType.equals(GroupEnum.FORECAST_DATE.getValue())) {
                Date date = row.getDate(drawType);
                fieldProperty = billInfo.get(drawType);
                propertyValue = (Date)fieldProperty.getPropertyValue();
                if (propertyValue.compareTo(date) == 0) continue;
                flag = Boolean.FALSE;
                break;
            }
            Long value = row.getLong(drawType);
            fieldProperty = billInfo.get(drawType);
            if (fieldProperty == null || value.compareTo((Long)(propertyValue = (Long)fieldProperty.getPropertyValue())) == 0) continue;
            flag = Boolean.FALSE;
            break;
        }
        return flag;
    }

    private Map<String, FieldProperty> buildPropertyColl(Row row, Map<String, DynamicObject> relationship) {
        LinkedHashMap<String, FieldProperty> fieldProperties = new LinkedHashMap<String, FieldProperty>(relationship.size());
        for (Map.Entry<String, DynamicObject> entry : relationship.entrySet()) {
            FieldProperty fieldProperty = this.buildProperty(entry.getKey(), entry.getValue(), row.get(entry.getKey()));
            fieldProperties.put(entry.getKey(), fieldProperty);
        }
        FieldProperty fieldProperty = this.buildPreValue(row);
        fieldProperties.put(fieldProperty.getSourceBillKey(), fieldProperty);
        return fieldProperties;
    }

    private FieldProperty buildPreValue(Row row) {
        FieldProperty fieldProperty = new FieldProperty();
        fieldProperty.setSourceBillKey("prevalue");
        fieldProperty.setPropertyValue(row.getBigDecimal("prevalue"));
        return fieldProperty;
    }

    private FieldProperty buildProperty(String sourceBillKey, DynamicObject relation, Object propertyValue) {
        FieldProperty fieldProperty = new FieldProperty();
        fieldProperty.setSourceBillKey(sourceBillKey);
        fieldProperty.setDrawBillKey(relation.getString("drawbillfieldkey"));
        fieldProperty.setDrawBillParentKey(relation.getString("drawbillfieldparent"));
        fieldProperty.setPropertyValue(propertyValue);
        return fieldProperty;
    }

    private Map<String, DynamicObject> getRelationship(DynamicObject billCreateScheme) {
        DynamicObjectCollection fieldMappingEntries = billCreateScheme.getDynamicObjectCollection("fieldmappingentry");
        LinkedHashMap<String, DynamicObject> map = new LinkedHashMap<String, DynamicObject>(16);
        for (DynamicObject entry : fieldMappingEntries) {
            if (entry.getString("drawbillfieldkey").isEmpty()) continue;
            map.put(entry.getString("forecastresultfieldkey"), entry);
        }
        return map;
    }
}

