/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.action.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.scmc.ism.business.action.impl.AbstractUpdLogAction;
import kd.scmc.ism.business.helper.BizFlowServiceHelper;
import kd.scmc.ism.common.consts.config.SettleLogConsts;
import kd.scmc.ism.common.model.log.SettleLogHandler;
import kd.scmc.ism.common.result.BatchBillOpResult;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.lang.ModelLang;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.flow.BillBatchFlowExecutor;

public class BillOperExecuteAction
extends AbstractUpdLogAction {
    @Override
    protected boolean isSkipAction() {
        return super.isSkipAction();
    }

    @Override
    protected void doAction() {
        this.doOperLogRecord(ModelLang.settleOp());
        this.saveLog();
        List<List<Long>> genSequences = this.getBillGenSequence();
        BillBatchFlowExecutor executor = new BillBatchFlowExecutor();
        Map<Long, SettleBillModel> gbillModels = this.getReqContext().getGenerateBillModels();
        if (CommonUtils.mapIsEmpty(gbillModels)) {
            return;
        }
        for (SettleBillModel billModel : gbillModels.values()) {
            executor.addNoSavedBill(billModel.getObj());
        }
        BatchBillOpResult positiveExecute = executor.positiveExecute(genSequences);
        this.updateLogAndResult(positiveExecute);
    }

    private void saveLog() {
        Map<Long, SettleLogHandler> allLogs = this.getReqContext().getAllLogs();
        Map<Long, String> bizTraceNos = BizFlowServiceHelper.getBizTraceNos(allLogs.keySet());
        ArrayList<DynamicObject> logObjs = new ArrayList<DynamicObject>(allLogs.size());
        ArrayList<Long> deleteSourceBillIds = new ArrayList<Long>(allLogs.size());
        for (Map.Entry<Long, SettleLogHandler> entry : allLogs.entrySet()) {
            Long srcbillId = entry.getKey();
            SettleLogHandler loggerhander = entry.getValue();
            String biztraceNo = bizTraceNos.get(srcbillId);
            if (StringUtils.isEmpty((CharSequence)biztraceNo)) {
                biztraceNo = "ism_traceno_" + srcbillId;
            }
            loggerhander.setBizTraceNo(biztraceNo);
            DynamicObject saveLog = loggerhander.preSaveLog(this.getServiceContext());
            logObjs.add(saveLog);
            Long sourceBillIds = saveLog.getLong("sourceid");
            deleteSourceBillIds.add(sourceBillIds);
        }
        if (CommonUtils.collectionIsEmpty(logObjs)) {
            return;
        }
        QFilter deleteFilter = new QFilter("createstatus", "in", (Object)SettleLogConsts.getNoSuccessStatus());
        deleteFilter.and("sourceid", "in", deleteSourceBillIds);
        try (TXHandle h = TX.requiresNew((String)"saveSettlelog");){
            try {
                DeleteServiceHelper.delete((String)"ism_settlelog", (QFilter[])deleteFilter.toArray());
                SaveServiceHelper.save((DynamicObject[])logObjs.toArray(new DynamicObject[logObjs.size()]));
            }
            catch (Exception e) {
                log.info("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25..." + e.getMessage());
                log.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                h.markRollback();
                throw e;
            }
        }
    }
}

