/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.action.impl;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.business.action.AbstractSettleAction;
import kd.scmc.ism.business.helper.algorithm.SimpleAlgorithmForBotp;
import kd.scmc.ism.business.helper.algorithm.TaxAlgorithmForBotp;
import kd.scmc.ism.business.helper.recalprice.OrderBillAmountReCalHelper;
import kd.scmc.ism.business.helper.recalprice.arap.ApBillAmountReCalHelper;
import kd.scmc.ism.business.helper.recalprice.arap.ArBillAmountReCalHelper;
import kd.scmc.ism.model.bill.impl.SettleBillModel;

public class GeneratedBillRecalAction
extends AbstractSettleAction {
    @Override
    protected boolean isSkipAction() {
        return super.isSkipAction() || this.getReqContext().getGenerateBillModels().isEmpty();
    }

    @Override
    protected void doAction() {
        Map<Long, SettleBillModel> generateBillModels = this.getReqContext().getGenerateBillModels();
        for (SettleBillModel billModel : generateBillModels.values()) {
            String type;
            DynamicObject data = billModel.getObj();
            switch (type = data.getDataEntityType().getName()) {
                case "im_purinbill": 
                case "im_saloutbill": 
                case "im_mdc_omcmplinbill": {
                    TaxAlgorithmForBotp algo = new TaxAlgorithmForBotp(data);
                    algo.reCalFields();
                    break;
                }
                case "im_transinbill": 
                case "im_transoutbill": {
                    SimpleAlgorithmForBotp transAlgo = new SimpleAlgorithmForBotp(data, "settlescurrency");
                    transAlgo.reCalFields();
                    break;
                }
                case "sm_salorder": 
                case "pm_purorderbill": {
                    OrderBillAmountReCalHelper.orderBillAmountReCal(data);
                    break;
                }
                case "ap_finapbill": {
                    ApBillAmountReCalHelper.apBillAmountReCal(data);
                    break;
                }
                case "ar_finarbill": {
                    ArBillAmountReCalHelper.arBillAmountReCal(data);
                    break;
                }
            }
        }
    }
}

