/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.action.impl.pricing;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.business.action.AbstractSettleAction;
import kd.scmc.ism.business.helper.CurrencyHelper;
import kd.scmc.ism.common.consts.imconst.BigDecimalConstants;
import kd.scmc.ism.common.model.mapper.ExRateCacheMapper;
import kd.scmc.ism.common.model.mapper.MaterialUnitConvertMapper;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;
import kd.scmc.ism.model.bill.impl.SettleBillEntryModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;

public abstract class AbstractPriceAdditionAction
extends AbstractSettleAction {
    protected void handlePrcie(ExRateCacheMapper exRateService, Long settleCurrencyId, Date exrateDate, CoupleSettleBillEntriesModel cpEntryModel) {
        long priceCurrencyId = cpEntryModel.getPriceCurrencyId();
        if (CommonUtils.idIsNotNull(priceCurrencyId) && settleCurrencyId != null && !settleCurrencyId.equals(0L)) {
            SettleBillModel srcbillModel = (SettleBillModel)cpEntryModel.getBillModel().getSrcBillModel();
            long srcExRateTableId = srcbillModel.getExRateTableId();
            BigDecimal exRate = exRateService.getExRate(srcExRateTableId, priceCurrencyId, settleCurrencyId, exrateDate);
            String quotation = exRateService.getQuotation(srcExRateTableId, priceCurrencyId, settleCurrencyId, exrateDate);
            if (exRate == null) {
                log.info(String.format("\u5206\u5f55\u3010%s\u3011\u53d6\u6c47\u7387\u5931\u8d25\u3002srcCur:%s,tgtCur:%s,extable:%s,exdate:%s.", cpEntryModel.getId(), priceCurrencyId, settleCurrencyId, srcExRateTableId, exrateDate));
                return;
            }
            cpEntryModel.setCalPriceWithTax(this.doPriceAddition(cpEntryModel, cpEntryModel.getRePriceWithTax(), exRate, quotation));
            cpEntryModel.setCalPrice(this.doPriceAddition(cpEntryModel, cpEntryModel.getRePrice(), exRate, quotation));
            this.setPrice(cpEntryModel);
            this.handleGiftEntry(cpEntryModel);
        }
    }

    private void handleGiftEntry(CoupleSettleBillEntriesModel cpEntryModel) {
        if (!(cpEntryModel.getCalPrice() != null && BigDecimal.ZERO.compareTo(cpEntryModel.getCalPrice()) != 0 || cpEntryModel.getCalPriceWithTax() != null && BigDecimal.ZERO.compareTo(cpEntryModel.getCalPriceWithTax()) != 0)) {
            return;
        }
        for (SettleBillEntryModel entryModel : cpEntryModel.getModels()) {
            Boolean isGift = entryModel.getValueWithDef("isgift", Boolean.FALSE);
            if (!isGift.booleanValue()) continue;
            String billEntityType = entryModel.getBillEntityType();
            if ("ap_finapbill".equals(billEntityType) || "ar_finarbill".equals(billEntityType)) {
                entryModel.setValue("discounttype", "PERCENT");
            } else {
                entryModel.setValue("discounttype", "A");
            }
            entryModel.setValue("discountrate", BigDecimal.valueOf(100L));
        }
        cpEntryModel.getModels();
    }

    private BigDecimal doPriceAddition(CoupleSettleBillEntriesModel cpEntryModel, BigDecimal price, BigDecimal exRate, String quotation) {
        if (price != null) {
            BigDecimal rePrice = CurrencyHelper.exrateExchange(price, quotation, exRate);
            DynamicObject priceEntry = cpEntryModel.getPriceRuleEntryObj();
            if (priceEntry != null && cpEntryModel.isPricing()) {
                BigDecimal addnPrice;
                ArrayList<BigDecimal> addDecimals = new ArrayList<BigDecimal>(2);
                BigDecimal addnratio = priceEntry.getBigDecimal("addnratio");
                if (addnratio.compareTo(BigDecimal.ZERO) != 0) {
                    addDecimals.add(rePrice.multiply(addnratio.divide(BigDecimalConstants.ONEHUNDRED)));
                }
                if ((addnPrice = priceEntry.getBigDecimal("addnfixedprice")).compareTo(BigDecimal.ZERO) != 0) {
                    addDecimals.add(addnPrice);
                }
                for (BigDecimal addPrice : addDecimals) {
                    rePrice = rePrice.add(addPrice);
                }
            }
            if (cpEntryModel.isUnitConvert()) {
                MaterialUnitConvertMapper unitConvertMapper = this.getServiceContext().getService(MaterialUnitConvertMapper.class);
                Long matId = DynamicObjectUtil.getMaterialMasterId((DynamicObject)cpEntryModel.getValue("material"));
                Long unitId = DynamicObjectUtil.getPkValue((DynamicObject)cpEntryModel.getValue("unit"));
                rePrice = unitConvertMapper.getUnitConvert(matId, rePrice, cpEntryModel.getPriceUnit(), unitId);
            }
            return rePrice;
        }
        return price;
    }

    private void setPrice(CoupleSettleBillEntriesModel cpEntryModel) {
        for (SettleBillEntryModel entryModel : cpEntryModel.getModels()) {
            SettleBillModel billModel = entryModel.getBillModel();
            Boolean isHasTax = billModel.getValueWithDef("istax", Boolean.FALSE);
            if (isHasTax.booleanValue()) {
                BigDecimal rePriceTax = cpEntryModel.getCalPriceWithTax();
                if (rePriceTax == null) continue;
                entryModel.setValue("priceandtax", rePriceTax);
                continue;
            }
            BigDecimal rePrice = cpEntryModel.getCalPrice();
            if (rePrice == null) continue;
            entryModel.setValue("price", rePrice);
        }
    }
}

