/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.action.impl.pricing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ism.business.action.impl.pricing.AbstractPricingAction;
import kd.scmc.ism.common.model.assist.MainBillAssistant;
import kd.scmc.ism.common.model.assist.OrgAssistant;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.bill.ISettleBillModel;
import kd.scmc.ism.model.bill.impl.AbstractCoupleSettleBillsModel;
import kd.scmc.ism.model.bill.impl.AbstractSettleBillModel;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillsModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.group.rel.collect.DataGroupCollector;
import kd.scmc.ism.model.match.engine.impl.PriceRuleEntryMatchEngine;
import kd.scmc.ism.model.match.engine.impl.PriceRuleMatchEngine;
import kd.scmc.ism.model.match.entity.MatchArgs;
import kd.scmc.ism.model.match.entity.MatchResult;
import kd.scmc.ism.model.match.loader.impl.EntryDataLoader;
import kd.scmc.ism.model.match.unit.impl.PriceRuleEntryMatchUnit;
import kd.scmc.ism.model.match.unit.impl.PriceRuleMatchUnit;

public class PriceRuleMatchAction
extends AbstractPricingAction {
    private PriceRuleMatchEngine prEngine;
    private PriceRuleEntryMatchEngine preEngine;

    @Override
    protected void doAction() {
        this.preLoadData();
        if (!this.isPricingFail()) {
            this.initGroupInfo();
            this.doMatchPriceRule();
        }
    }

    private void preLoadData() {
        OrgAssistant orgAssistant = this.getServiceContext().getOrgAssistant();
        MainBillAssistant billAssistant = this.getServiceContext().getBillAssistant();
        List<CoupleSettleBillsModel> billInfos = this.getReqContext().getSupDemBillInfos();
        HashSet<Long> supplierIds = new HashSet<Long>(billInfos.size());
        HashSet<Long> demandIds = new HashSet<Long>(billInfos.size());
        HashSet<Long> priceRuleIds = new HashSet<Long>(billInfos.size());
        for (CoupleSettleBillsModel cpModel : billInfos) {
            supplierIds.add(cpModel.getSupplierId());
            demandIds.add(cpModel.getDemandId());
            DynamicObject entrySettleRelation = cpModel.getEntrySettleRelation();
            if (entrySettleRelation != null) {
                Long priceRuleId = DynamicObjectUtil.getPkValue(entrySettleRelation.getDynamicObject("interorgsettlerule"));
                priceRuleIds.add(priceRuleId);
            }
            String billentity = (String)cpModel.getValue("mainbillentity");
            Long billId = (Long)cpModel.getValue("mainbillid");
            billAssistant.preLoadData(billentity, billId);
        }
        orgAssistant.preLoadDatas(supplierIds);
        orgAssistant.preLoadDatas(demandIds);
        this.doPriceRuleLoad(supplierIds, demandIds, priceRuleIds);
    }

    private void doPriceRuleLoad(Set<Long> supplierIds, Set<Long> demandIds, Set<Long> priceRuleIds) {
        demandIds.add(0L);
        supplierIds.add(0L);
        QFilter idQFilter = new QFilter("id", "in", priceRuleIds);
        QFilter supDmdFilter = new QFilter("supplier", "in", supplierIds).and("demand", "in", demandIds);
        QFilter commonQFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{idQFilter.or(supDmdFilter), commonQFilter};
        Map priceRules = BusinessDataServiceHelper.loadFromCache((String)"ism_interorgsettlerule", (QFilter[])filters);
        if (priceRules.isEmpty()) {
            this.markPricingFail();
        } else {
            this.getPrEngine().loadObjs(priceRules.values());
            Collection<DynamicObject> priceRuleEntries = EntryDataLoader.build(priceRules.values()).getObjects();
            this.getPreEngine().loadObjs(priceRuleEntries);
        }
    }

    private void initGroupInfo() {
        List<CoupleSettleBillsModel> billInfos = this.getReqContext().getSupDemBillInfos();
        ArrayList<SettleBillModel> models = new ArrayList<SettleBillModel>(16);
        for (CoupleSettleBillsModel cpModel : billInfos) {
            models.addAll(cpModel.getModels());
            models.add((SettleBillModel)cpModel.getSrcBillModel());
        }
        DataGroupCollector collector = DataGroupCollector.create(this.getServiceContext().getMatchCfg(), this.getServiceContext().getCtrlInfos());
        collector.collect(models, this.getPrEngine().getAllObjs());
        this.getServiceContext().getClassfier().loadCollectData(collector);
    }

    private void doMatchPriceRule() {
        boolean isMatched = false;
        List<CoupleSettleBillsModel> billInfos = this.getReqContext().getSupDemBillInfos();
        for (CoupleSettleBillsModel cpModel : billInfos) {
            DynamicObject entrySettleRelation = cpModel.getEntrySettleRelation();
            Long priceRuleId = 0L;
            String matchType = null;
            if (entrySettleRelation != null) {
                priceRuleId = DynamicObjectUtil.getPkValue(entrySettleRelation.getDynamicObject("interorgsettlerule"));
                matchType = entrySettleRelation.getString("pricematchtype");
            } else {
                matchType = cpModel.getSupBillModel() != null ? "1" : (cpModel.getDemBillModel() != null ? "2" : "0");
            }
            MatchArgs prArgs = MatchArgs.buildMatch(this.getMatchBillModel(cpModel, matchType));
            prArgs.setResultId(priceRuleId);
            prArgs.putAddtionInfo("supplier", cpModel.getSupplierId());
            prArgs.putAddtionInfo("demand", cpModel.getDemandId());
            MatchResult<PriceRuleMatchUnit> prMatchResult = this.getPrEngine().doMatch(prArgs);
            if (!prMatchResult.isMatch()) continue;
            isMatched = true;
            DynamicObject priceRuleObj = prMatchResult.getMatchedUnit().getResultObject();
            cpModel.setPriceRuleObj(priceRuleObj);
            List<CoupleSettleBillEntriesModel> entries = cpModel.getEntries();
            for (CoupleSettleBillEntriesModel cpEntryModel : entries) {
                if (!cpEntryModel.isPricing()) continue;
                MatchArgs preArgs = MatchArgs.buildMatch(this.getMatchBillModel(cpEntryModel, matchType));
                preArgs.putAddtionInfo("id", prMatchResult.getMatchedUnit().getResultObjId());
                MatchResult preMatchResult = this.getPreEngine().doMatch(preArgs);
                if (!preMatchResult.isMatch()) continue;
                cpEntryModel.setPriceRuleEntryObj(((PriceRuleEntryMatchUnit)preMatchResult.getMatchedUnit()).getResultObject());
            }
        }
        if (!isMatched) {
            this.markPricingFail();
        }
    }

    private ISettleBillModel getMatchBillModel(AbstractCoupleSettleBillsModel<? extends AbstractSettleBillModel> cpModel, String matchType) {
        AbstractSettleBillModel matchBillModel = null;
        switch (matchType) {
            case "1": {
                matchBillModel = cpModel.getSupBillModel();
                break;
            }
            case "2": {
                matchBillModel = cpModel.getDemBillModel();
                break;
            }
            default: {
                matchBillModel = cpModel.getSrcBillModel();
            }
        }
        return matchBillModel;
    }

    public PriceRuleMatchEngine getPrEngine() {
        if (this.prEngine == null) {
            this.prEngine = PriceRuleMatchEngine.build();
        }
        return this.prEngine;
    }

    public PriceRuleEntryMatchEngine getPreEngine() {
        if (this.preEngine == null) {
            this.preEngine = PriceRuleEntryMatchEngine.build(this.getServiceContext());
        }
        return this.preEngine;
    }
}

