/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.action.impl.pricing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.MulComboProp;
import kd.scmc.ism.business.action.impl.pricing.AbstractPricingAction;
import kd.scmc.ism.common.model.level.CurrencySrcLevelModel;
import kd.scmc.ism.common.model.level.ExrateSrcLevelModel;
import kd.scmc.ism.common.model.level.SettlePriceSrcLevelModel;
import kd.scmc.ism.common.model.level.TaxSrcLevelModel;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.log.PricingTypeLogHandler;
import kd.scmc.ism.common.model.mapper.DynamicObjectCacheMapper;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillsModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;

public class SettlePricingAction
extends AbstractPricingAction {
    private BasedataEntityType entity = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"ism_interorgsettlerule");

    @Override
    protected void doAction() {
        List<CoupleSettleBillsModel> cpBillInfos = this.getReqContext().getSupDemBillInfos();
        ArrayList<CoupleSettleBillEntriesModel> cpBillEntries = new ArrayList<CoupleSettleBillEntriesModel>(cpBillInfos.size() * 16);
        for (CoupleSettleBillsModel cpBillModel : cpBillInfos) {
            cpBillEntries.addAll(cpBillModel.getEntries());
        }
        PricingLogHandler logHandler = this.getReqContext().getPricingLogHandler();
        if (CommonUtils.collectionIsNotEmpty(cpBillInfos)) {
            ExrateSrcLevelModel exrateModel = new ExrateSrcLevelModel(this.getServiceContext());
            exrateModel.initPricingKeyMap(this.getPricingKeyValue("exratesrc"));
            exrateModel.bacthProcessing(this.getReqContext(), cpBillInfos);
            PricingTypeLogHandler exrateLog = logHandler.getTypeLogHandler("exrate");
            log.info("\u7ec4\u7ec7\u95f4\u7ed3\u7b97 \u53d6\u6c47\u7387\uff1a" + exrateLog.getLogInfo());
            CurrencySrcLevelModel currencyModel = new CurrencySrcLevelModel(this.getServiceContext());
            currencyModel.initPricingKeyMap(this.getPricingKeyValue("currencysource"));
            currencyModel.bacthProcessing(this.getReqContext(), cpBillInfos);
            PricingTypeLogHandler currencyLog = logHandler.getTypeLogHandler("currency");
            log.info("\u7ec4\u7ec7\u95f4\u7ed3\u7b97 \u53d6\u5e01\u522b\uff1a" + currencyLog.getLogInfo());
        }
        this.preSetCurrency(cpBillInfos);
        if (CommonUtils.collectionIsNotEmpty(cpBillEntries)) {
            SettlePriceSrcLevelModel settlePrice = new SettlePriceSrcLevelModel(this.getServiceContext());
            settlePrice.initPricingKeyMap(this.getPricingKeyValue("settlesource"));
            settlePrice.bacthProcessing(this.getReqContext(), cpBillEntries);
            PricingTypeLogHandler priceLog = logHandler.getTypeLogHandler("price");
            log.info("\u7ec4\u7ec7\u95f4\u7ed3\u7b97 \u53d6\u4ef7\u683c\uff1a" + priceLog.getLogInfo());
            TaxSrcLevelModel taxModel = new TaxSrcLevelModel(this.getServiceContext());
            taxModel.initPricingKeyMap(this.getPricingKeyValue("taxsource"));
            taxModel.bacthProcessing(this.getReqContext(), cpBillEntries);
            PricingTypeLogHandler taxRateLog = logHandler.getTypeLogHandler("taxrate");
            log.info("\u7ec4\u7ec7\u95f4\u7ed3\u7b97 \u53d6\u7a0e\u7387\uff1a" + taxRateLog.getLogInfo());
        }
    }

    private void preSetCurrency(List<CoupleSettleBillsModel> cpBillInfos) {
        DynamicObjectCacheMapper doMapper = this.getServiceContext().getService(DynamicObjectCacheMapper.class);
        for (CoupleSettleBillsModel cpBillsModel : cpBillInfos) {
            DynamicObject settleCurrency = doMapper.get("bd_currency", cpBillsModel.getSettleCurrencyId());
            if (settleCurrency == null) continue;
            for (SettleBillModel billModel : cpBillsModel.getModels()) {
                billModel.setValueToObj("settlecy", settleCurrency);
            }
        }
    }

    public Map<String, String> getPricingKeyValue(String fieldKey) {
        MulComboProp prop = (MulComboProp)this.entity.findProperty(fieldKey);
        List comboItems = prop.getComboItems();
        HashMap<String, String> keyValue = new HashMap<String, String>(16);
        for (ValueMapItem valueMapItem : comboItems) {
            keyValue.put(valueMapItem.getValue(), valueMapItem.getName().getLocaleValue());
        }
        return keyValue;
    }
}

