/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.action.impl.vali;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.business.action.AbstractSettleAction;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.bill.impl.SettleBillEntryModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.mapcfg.fieldinfo.BillFieldInfo;
import kd.scmc.ism.model.match.entity.MatchResult;
import kd.scmc.ism.model.match.unit.impl.SettleJudgeMatchUnit;

public class ValidateSettleAction
extends AbstractSettleAction {
    @Override
    protected boolean isSkipAction() {
        return super.isSkipAction() || CommonUtils.collectionIsEmpty(this.getReqContext().getSrcBillModels());
    }

    @Override
    protected void doAction() {
        ISMRequestContext reqContext = this.getReqContext();
        Collection<SettleBillModel> srcBillModels = reqContext.getSrcBillModels();
        Map<Long, MatchResult<?>> judgeUnits = reqContext.getMatchUnits(SettleJudgeMatchUnit.class);
        block0: for (SettleBillModel billModel : srcBillModels) {
            Long billId = billModel.getId();
            DynamicObject billObj = billModel.getObj();
            SettleJudgeMatchUnit settleJudgeUnit = (SettleJudgeMatchUnit)judgeUnits.get(billId).getMatchedUnit();
            List<SettleBillEntryModel> entries = billModel.getEntries();
            for (SettleBillEntryModel entryModel : entries) {
                DynamicObject demand;
                DynamicObject supplier;
                DynamicObject relationObj;
                DynamicObject entryObj = entryModel.getObj();
                if (settleJudgeUnit.isConfigSettleRelation() && (relationObj = this.getObject(billObj, entryObj, settleJudgeUnit.getSettleRelationKey())) != null) {
                    reqContext.getOperResult().addFailInfo(billId, "nosettle");
                    continue block0;
                }
                if (!settleJudgeUnit.isConfigSupAndDem() || DynamicObjectUtil.checkIsNotOrg(supplier = this.getObject(billObj, entryObj, settleJudgeUnit.getSettleOrgKey()), demand = this.getObject(billObj, entryObj, settleJudgeUnit.getOwnerOrgKey()))) continue;
                Long supplierId = DynamicObjectUtil.getPkValue(supplier);
                Long demandId = DynamicObjectUtil.getPkValue(demand);
                if (!CommonUtils.idIsNotNull(supplierId) || !CommonUtils.idIsNotNull(demandId) || supplierId.equals(demandId)) continue;
                reqContext.getOperResult().addFailInfo(billId, "nosettle");
                continue block0;
            }
        }
    }

    private DynamicObject getObject(DynamicObject bill, DynamicObject entry, BillFieldInfo fieldInfo) {
        if (fieldInfo == null) {
            return null;
        }
        return (DynamicObject)fieldInfo.getValue(bill, entry);
    }
}

