/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.orm.query.QFilter;
import kd.scmc.ism.common.model.handler.BillFieldMapCfg;

public class BillFieldMappingDataHelper {
    public static DataSet parallelGetData(String algoKey, BillFieldMapCfg fieldMapCfg, Map<String, QFilter[]> billTypeFilters, String ... queryfields) {
        Algo algo = Algo.create((String)algoKey);
        ArrayList<OrmInput> billsIO = new ArrayList<OrmInput>(billTypeFilters.size());
        for (Map.Entry<String, QFilter[]> entry : billTypeFilters.entrySet()) {
            String billType = entry.getKey();
            QFilter[] filter = entry.getValue();
            OrmInput billIO = BillFieldMappingDataHelper.getInput(algoKey + billType, fieldMapCfg, billType, filter, queryfields);
            if (billIO == null) continue;
            billsIO.add(billIO);
        }
        if (billsIO.isEmpty()) {
            return null;
        }
        DataSet billsData = algo.createDataSet((Input[])billsIO.toArray(new OrmInput[billsIO.size()]));
        return billsData;
    }

    private static OrmInput getInput(String algoKey, BillFieldMapCfg fieldMapCfg, String billType, QFilter[] filter, String ... queryfields) {
        Map<String, String> srcBillDataMap = fieldMapCfg.getSrcBillDataMap(billType);
        if (srcBillDataMap == null) {
            return null;
        }
        StringBuilder str = new StringBuilder();
        str.append("id as billid,");
        String entryKey = srcBillDataMap.get("billentry");
        if (StringUtils.isEmpty((CharSequence)entryKey)) {
            str.append('0');
        } else {
            str.append(entryKey);
            str.append('.');
            str.append("id");
        }
        str.append(" as entryid, ");
        str.append(BillFieldMappingDataHelper.getSelectFieldStr(fieldMapCfg, billType, queryfields));
        OrmInput billIO = new OrmInput(algoKey, billType, str.toString(), filter);
        return billIO;
    }

    public static String getSelectFieldStr(BillFieldMapCfg cfg, String billType, String ... fields) {
        String[] billFields = BillFieldMappingDataHelper.getSelectFields(cfg, billType, fields);
        String selectedFields = BillFieldMappingDataHelper.billFieldsToStr(billFields);
        return selectedFields;
    }

    public static String[] getSelectFields(BillFieldMapCfg cfg, String billType, String ... fields) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ism_billmapcfg");
        String[] selectFields = new String[fields.length];
        for (int i = 0; i < selectFields.length; ++i) {
            String field = fields[i];
            String srcFieldNum = cfg.getSrcFieldNum(billType, field);
            if (StringUtils.isEmpty((CharSequence)srcFieldNum)) {
                IDataEntityProperty property = entityType.findProperty(field);
                srcFieldNum = property instanceof DecimalProp || property instanceof BooleanProp || property instanceof BasedataProp ? "0" : "''";
            }
            if ("material".equals(field)) {
                srcFieldNum = srcFieldNum + ".masterid";
            }
            selectFields[i] = srcFieldNum + " AS " + field;
        }
        return selectFields;
    }

    public static String[] buildSelectedFields(String[] headFields, String entrykey, String[] entryFields) {
        ArrayList<String> fields = new ArrayList<String>(headFields.length + entryFields.length);
        for (String headField : headFields) {
            fields.add(headField);
        }
        for (String entryField : entryFields) {
            StringBuilder str = new StringBuilder();
            str.append(entrykey);
            str.append('.');
            str.append(entryField);
            str.append(" AS ");
            str.append(entryField);
            fields.add(str.toString());
        }
        return fields.toArray(new String[0]);
    }

    public static String buildSelectedFieldsSrt(String[] headFields, String entrykey, String[] entryFields) {
        String[] billFields = BillFieldMappingDataHelper.buildSelectedFields(headFields, entrykey, entryFields);
        String selectedFields = BillFieldMappingDataHelper.billFieldsToStr(billFields);
        return selectedFields;
    }

    public static String billFieldsToStr(String[] billFields) {
        return Arrays.toString(billFields).replaceAll("\\[", "").replaceAll("\\]", "");
    }
}

