/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper;

import java.util.ArrayList;
import java.util.function.Consumer;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.form.operate.flowchart.AbstractViewFlowchart;

public class BizFlowShowHelper {
    public static void showBizFlowViewChart(IFormView view, String billEntityType, Long billId, Long bizFlowKey) {
        AbstractViewFlowchart vfc = new AbstractViewFlowchart();
        vfc.setEntityName(billEntityType);
        vfc.setBillId((Object)billId);
        vfc.showFlowchart(view, null, bizFlowKey);
    }

    public static void showBizFlowDesigner(final IFormView view, String bizFlowEditKey) {
        BasedataEdit bizFlow = (BasedataEdit)view.getControl(bizFlowEditKey);
        if (bizFlow == null) {
            return;
        }
        bizFlow.addBeforeF7ViewDetailListener((Consumer)new Consumer<BeforeF7ViewDetailEvent>(){

            @Override
            public void accept(BeforeF7ViewDetailEvent t) {
                t.setCancel(true);
                DesignerModelUtil.openBizFlowDesigner((Long)((Long)t.getPkId()), (IFormView)view);
            }
        });
    }

    public static ListShowParameter showHistoricalBizFlowByBillIds(Long ... billIds) {
        ArrayList<String> billIdStrs = new ArrayList<String>(billIds.length);
        for (Long billId : billIds) {
            billIdStrs.add(billId.toString());
        }
        QFilter histProcFilter = new QFilter("businesskey", "in", billIdStrs);
        return BizFlowShowHelper.showHistoricalBizFlow(histProcFilter);
    }

    public static ListShowParameter showHistoricalBizFlow(QFilter histProcFilter) {
        ListShowParameter params = new ListShowParameter();
        params.setBillFormId("bpm_historicalprocess");
        if (histProcFilter != null) {
            ListFilterParameter filterParam = new ListFilterParameter();
            filterParam.setFilter(histProcFilter);
            params.setListFilterParameter(filterParam);
        }
        params.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        params.setFormId("bos_list");
        return params;
    }
}

