/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.scmc.ism.business.helper.PageShowHelper;

public class BotpPushHepler {
    public static void showConvertRuleEdit(final IFormView view, String botpKey) {
        BasedataEdit botpIdEdit = (BasedataEdit)view.getControl(botpKey);
        if (botpIdEdit == null) {
            return;
        }
        botpIdEdit.addBeforeF7ViewDetailListener((Consumer)new Consumer<BeforeF7ViewDetailEvent>(){

            @Override
            public void accept(BeforeF7ViewDetailEvent t) {
                t.setCancel(true);
                Object pkId = t.getPkId();
                DynamicObject botpObj = BusinessDataServiceHelper.loadSingleFromCache((Object)pkId, (String)"botp_crlist");
                String srcEntity = botpObj.getString("sourceentitynumber.number");
                String tgtEntity = botpObj.getString("targetentitynumber.number");
                view.showForm(PageShowHelper.getBotpRuleParam(srcEntity, tgtEntity, t.getPkId()));
            }
        });
    }

    public static List<DynamicObject> botpGenetateTargetBill(DynamicObject obj, String targetEntityNumber) {
        return BotpPushHepler.botpGenetateTargetBill(obj, targetEntityNumber, null);
    }

    public static List<DynamicObject> botpGenetateTargetBill(DynamicObject obj, String targetEntityNumber, String ruleId) {
        PushArgs botp = BotpPushHepler.buildPushArgs(obj, targetEntityNumber, ruleId);
        ConvertOperationResult result = BotpPushHepler.push(botp);
        List<DynamicObject> targetOrder = BotpPushHepler.getTargetObjectWithRefence(result);
        return targetOrder;
    }

    public static ConvertOperationResult botpGenetateTargetBillByResult(DynamicObject obj, String targetEntityNumber) {
        return BotpPushHepler.botpGenetateTargetBillByResult(obj, targetEntityNumber, null);
    }

    public static ConvertOperationResult botpGenetateTargetBillByResult(DynamicObject obj, String targetEntityNumber, String ruleId) {
        PushArgs botp = BotpPushHepler.buildPushArgs(obj, targetEntityNumber, ruleId);
        ConvertOperationResult result = BotpPushHepler.push(botp);
        return result;
    }

    public static ConvertOperationResult push(PushArgs pushArgs) {
        return ConvertServiceHelper.push((PushArgs)pushArgs);
    }

    public static List<DynamicObject> getTargetObject(ConvertOperationResult result) {
        if (!result.isSuccess()) {
            return null;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)result.getTargetEntityNumber());
        List targetOrder = result.loadTargetDataObjects(new IRefrencedataProvider(){

            public void fillReferenceData(Object[] paramArrayOfObject, IDataEntityType paramIDataEntityType) {
            }
        }, mainType);
        return targetOrder;
    }

    public static List<DynamicObject> getTargetObjectWithRefence(ConvertOperationResult result) {
        if (!result.isSuccess()) {
            return null;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)result.getTargetEntityNumber());
        List targetOrder = result.loadTargetDataObjects(new IRefrencedataProvider(){

            public void fillReferenceData(Object[] paramArrayOfObject, IDataEntityType paramIDataEntityType) {
                BusinessDataServiceHelper.loadRefence((Object[])paramArrayOfObject, (IDataEntityType)paramIDataEntityType);
            }
        }, mainType);
        return targetOrder;
    }

    public static PushArgs buildPushArgs(DynamicObject obj, String targetEntityNumber, String ruleId) {
        return BotpPushHepler.buildPushArgs(obj, "billentry", targetEntityNumber, ruleId);
    }

    public static PushArgs buildPushArgs(DynamicObject obj, String filedKey, String targetEntityNumber, String ruleId) {
        PushArgs botp = new PushArgs();
        ArrayList<ListSelectedRow> sourceBill = new ArrayList<ListSelectedRow>();
        DynamicObjectCollection eids = obj.getDynamicObjectCollection(filedKey);
        for (DynamicObject eid : eids) {
            ListSelectedRow row = new ListSelectedRow(obj.getPkValue(), Boolean.TRUE);
            row.setEntryEntityKey(filedKey);
            row.setEntryPrimaryKeyValue(eid.get("id"));
            sourceBill.add(row);
        }
        botp.setSourceEntityNumber(obj.getDataEntityType().getName());
        botp.setTargetEntityNumber(targetEntityNumber);
        botp.setSelectedRows(sourceBill);
        botp.setRuleId(ruleId);
        return botp;
    }
}

