/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.mapcfg.fieldinfo.CtrlInfo;

public class CtrlInfoChecker {
    private Map<String, CtrlInfo> ctrlMap = new HashMap<String, CtrlInfo>();

    public boolean isOnCtrlStrategy(String entityID) {
        return this.getCtrlStrategy(entityID).isOnCtrlStrategy();
    }

    public CtrlInfo getCtrlStrategy(String entityID) {
        CtrlInfo ctrlInfo = this.ctrlMap.get(entityID);
        if (ctrlInfo == null) {
            ctrlInfo = new CtrlInfo();
            BasedataEntityType dataPropEntity = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entityID);
            String masteridPropName = dataPropEntity.getMasteridPropName();
            boolean isOnCtrl = dataPropEntity.findProperty("ctrlstrategy") != null && StringUtils.isNotEmpty((CharSequence)masteridPropName);
            ctrlInfo.setOnCtrlStrategy(isOnCtrl, masteridPropName);
            this.ctrlMap.put(entityID, ctrlInfo);
        }
        return ctrlInfo;
    }

    public Long getMasterId(DynamicObject dynaObj) {
        String entity = dynaObj.getDataEntityType().getName();
        CtrlInfo ctrlStrategy = this.getCtrlStrategy(entity);
        if (ctrlStrategy.isOnCtrlStrategy()) {
            Object masterObj = dynaObj.get(ctrlStrategy.getMasteridKey());
            if (masterObj instanceof DynamicObject) {
                return DynamicObjectUtil.getPkValue((DynamicObject)masterObj);
            }
            return (Long)masterObj;
        }
        return DynamicObjectUtil.getPkValue(dynaObj);
    }
}

