/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.ism.business.helper.BillBusinessHelper;
import kd.scmc.ism.business.helper.SettleLogHelper;
import kd.scmc.ism.common.model.entity.BillExecSequence;
import kd.scmc.ism.common.model.entity.BillExecuteInfo;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;

public class InterOrgBizHelper {
    @Deprecated
    public static Map<Long, Map<Long, DynamicObject>> getBillSettleLogInfo(String billtype, List<Long> billIds) {
        return InterOrgBizHelper.getBillSettleLogInfoBySrcBillIds(billIds);
    }

    public static Map<Long, Map<Long, DynamicObject>> getBillSettleLogInfoByLogIds(Collection<Long> logIds) {
        DynamicObject[] successLogs = SettleLogHelper.getSimpleLogInfo(new QFilter("id", "in", logIds));
        return InterOrgBizHelper.getBillInfoMapBySettleLog(successLogs);
    }

    @Deprecated
    public static Map<Long, Map<Long, DynamicObject>> getBillSettleLogInfoBySrcBillIds(Collection<Long> billIds) {
        HashMap<Long, Map<Long, DynamicObject>> settleLogInfos = new HashMap<Long, Map<Long, DynamicObject>>(billIds.size());
        try (TraceSpan trace = Tracer.create((String)"InterOrgBizHelper", (String)"getBillSettleLogInfoBySrcBillIds(billIds)");){
            for (Long billId : billIds) {
                settleLogInfos.put(billId, null);
            }
            DynamicObject[] successLogs = SettleLogHelper.getSimpleLogInfo(new QFilter("sourceid", "in", billIds));
            Map<Long, Map<Long, DynamicObject>> logInfoMaps = InterOrgBizHelper.getBillInfoMapBySettleLog(successLogs);
            settleLogInfos.putAll(logInfoMaps);
        }
        return settleLogInfos;
    }

    private static Map<Long, Map<Long, DynamicObject>> getBillInfoMapBySettleLog(DynamicObject ... settleLogs) {
        HashMap<Long, Map<Long, DynamicObject>> settleLogInfos = new HashMap<Long, Map<Long, DynamicObject>>(64);
        if (CommonUtils.arrayIsEmpty(settleLogs)) {
            return settleLogInfos;
        }
        HashMap billEntityToSettleBill = new HashMap(64);
        for (DynamicObject logInfo : settleLogs) {
            Long billId = logInfo.getLong("sourceid");
            DynamicObjectCollection logEntries = logInfo.getDynamicObjectCollection("entryentity");
            Map<Long, DynamicObject> billInfos = CommonUtils.mapGetLinkedMapValue(settleLogInfos, billId);
            for (DynamicObject logEntry : logEntries) {
                long settleBillId = logEntry.getLong("settlebillid");
                String billentity = logEntry.getDynamicObject("settlebilltype").getString("number");
                List entityBillIds = CommonUtils.mapGetListValue(billEntityToSettleBill, billentity);
                entityBillIds.add(settleBillId);
                billInfos.put(settleBillId, null);
            }
        }
        HashMap<Long, DynamicObject> queryedBills = new HashMap<Long, DynamicObject>(64);
        for (Map.Entry settleBillEntry : billEntityToSettleBill.entrySet()) {
            DynamicObject[] billObjs;
            String entityName = (String)settleBillEntry.getKey();
            for (DynamicObject billObj : billObjs = BillBusinessHelper.getSimpleBillInfo(entityName, (Collection)settleBillEntry.getValue())) {
                queryedBills.put(DynamicObjectUtil.getPkValue(billObj), billObj);
            }
        }
        for (Map allObj : settleLogInfos.values()) {
            for (Map.Entry obj : allObj.entrySet()) {
                obj.setValue(queryedBills.get(obj.getKey()));
            }
        }
        return settleLogInfos;
    }

    public static Map<Long, DynamicObject> getBillInfosByBillExecSeq(Collection<BillExecSequence> billExecSeqs) {
        if (CommonUtils.collectionIsEmpty(billExecSeqs)) {
            return new HashMap<Long, DynamicObject>(0);
        }
        HashMap billEntityToSettleBill = new HashMap(64);
        for (BillExecSequence billExecSeq : billExecSeqs) {
            List<BillExecuteInfo> billExecuteInfos = billExecSeq.getAllExecSequence();
            for (BillExecuteInfo billExecuteInfo : billExecuteInfos) {
                long settleBillId = billExecuteInfo.getBillId();
                String billentity = billExecuteInfo.getBillEntityType();
                List entityBillIds = CommonUtils.mapGetListValue(billEntityToSettleBill, billentity);
                entityBillIds.add(settleBillId);
            }
        }
        HashMap<Long, DynamicObject> queryedBills = new HashMap<Long, DynamicObject>(64);
        for (Map.Entry settleBillEntry : billEntityToSettleBill.entrySet()) {
            DynamicObject[] billObjs;
            String entityName = (String)settleBillEntry.getKey();
            for (DynamicObject billObj : billObjs = BillBusinessHelper.getSimpleBillInfo(entityName, (Collection)settleBillEntry.getValue())) {
                queryedBills.put(DynamicObjectUtil.getPkValue(billObj), billObj);
            }
        }
        return queryedBills;
    }
}

