/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;

public class JobHelper {
    public static JobInfo buildJobInfo(String JobId, String taskDefineId, Map<String, Object> jobParams) {
        JobInfo job = new JobInfo();
        job.setRunByLang(Lang.get());
        job.setRunByUserId(RequestContext.get().getCurrUserId());
        job.setParams(jobParams);
        job.setId(JobId);
        job.setTaskDefineId(taskDefineId);
        return job;
    }

    public static JobInfo buildJobInfo(String jobId, String className, String jobName, Map<String, Object> params) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setId(jobId);
        jobInfo.setAppId("ism");
        jobInfo.setName(jobName);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setTaskClassname(className);
        jobInfo.setParams(params);
        return jobInfo;
    }

    public static JobInfo getJobInfo(Class<?> taskClass, String defaultJobName) {
        String taskName;
        JobInfo job = new JobInfo();
        job.setRunByLang(Lang.get());
        switch (taskName = taskClass.getName()) {
            case "kd.scmc.ism.task.ExecuteBizFlowTask": {
                job.setId("1302763783764290560");
                job.setTaskDefineId("1312439501121019904");
                break;
            }
            case "kd.scmc.ism.task.InnerSettleTask": {
                job.setId("1401455348736416768");
                job.setTaskDefineId("1194916813344012288");
                break;
            }
            case "kd.scmc.ism.task.InnerUnSettleTask": {
                job.setId("1194911889533106177");
                job.setTaskDefineId("1194913040928274432");
                break;
            }
            default: {
                if (StringUtils.isEmpty((CharSequence)defaultJobName)) {
                    job.setName(taskClass.getSimpleName());
                    break;
                }
                job.setName(defaultJobName);
            }
        }
        job.setTaskClassname(taskName);
        return job;
    }
}

