/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper;

import java.util.Date;
import java.util.List;
import kd.bos.config.client.util.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;

public class MatchConditionHelper {
    public static boolean isOnEffective(Date time, Date startTime, Date endTime) {
        return MatchConditionHelper.isAfterStart(startTime, time) && MatchConditionHelper.isBeforeEnd(endTime, time);
    }

    private static boolean isAfterStart(Date startDate, Date bizTime) {
        if (startDate == null) {
            return true;
        }
        return bizTime != null && startDate.compareTo(bizTime) <= 0;
    }

    private static boolean isBeforeEnd(Date endDate, Date bizTime) {
        if (endDate == null) {
            return true;
        }
        return bizTime != null && endDate.compareTo(bizTime) >= 0;
    }

    public static String buildExpression(DynamicObjectCollection mcEntries) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"ism_billmapcfg");
        StringBuilder exprBuilder = new StringBuilder();
        for (int i = 0; i < mcEntries.size(); ++i) {
            IDataEntityProperty property;
            DynamicObject mcEntry = (DynamicObject)mcEntries.get(i);
            String left = mcEntry.getString("left");
            if (!StringUtils.isEmpty((String)left)) {
                exprBuilder.append(left);
            }
            String key = mcEntry.getString("conditiondimkey");
            String cp = mcEntry.getString("comparison");
            if ("is not null".equals(cp) || "not null".equals(cp)) {
                property = entityType.findProperty(key);
                if (property instanceof BasedataProp) {
                    exprBuilder.append(String.format("%s not in (null,0)", key));
                } else {
                    exprBuilder.append(String.format("%s not in (null,'')", key));
                }
            } else if ("is null".equals(cp)) {
                property = entityType.findProperty(key);
                if (property instanceof BasedataProp) {
                    exprBuilder.append(String.format("%s in (null,0)", key));
                } else {
                    exprBuilder.append(String.format("%s in (null,'')", key));
                }
            } else {
                String conditionValueStr = mcEntry.getString("conditionvaluestr_tag");
                if (StringUtils.isNotEmpty((String)conditionValueStr)) {
                    List list = SerializationUtils.fromJsonStringToList((String)conditionValueStr, Object.class);
                    exprBuilder.append(new QFilter(key, cp, (Object)list).toString());
                }
            }
            String right = mcEntry.getString("right");
            if (!StringUtils.isEmpty((String)right)) {
                exprBuilder.append(right);
            }
            if (i >= mcEntries.size() - 1) continue;
            exprBuilder.append(" ");
            exprBuilder.append(mcEntry.getString("logic"));
            exprBuilder.append(" ");
        }
        return exprBuilder.toString();
    }
}

