/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper.algorithm;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.ism.business.helper.algorithm.AbstractAlgorithm;

public abstract class AbstractSimpleAlgorithm
extends AbstractAlgorithm {
    protected static Log log = LogFactory.getLog(AbstractSimpleAlgorithm.class);
    protected int amountPrecision = 2;
    protected int pricePrecision = 10;

    protected void initPrecision() {
        this.initPrecision("settlecurrency");
    }

    protected void initPrecision(String currencyKey) {
        DynamicObject currency = (DynamicObject)this.getValue(currencyKey);
        if (currency != null) {
            this.amountPrecision = currency.getInt("amtprecision");
        }
    }

    protected void calByQty(int i) {
        this.calAmount(i);
    }

    private void calAmount(int i) {
        BigDecimal price = this.getNullToZero("price", i);
        BigDecimal qty = this.getNullToZero("qty", i);
        BigDecimal amount = BigDecimal.ZERO;
        amount = qty.multiply(price).setScale(this.amountPrecision, 4);
        this.setValue("amount", amount, i);
    }
}

