/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper.inputconsts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.botp.CRValByConditions;
import kd.bos.entity.botp.runtime.ConvertFuncLoader;
import kd.bos.entity.function.FunctionGroup;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.scmc.ism.business.helper.inputconsts.AbstractInputConstsHandler;
import kd.scmc.ism.common.model.args.InputConstsResult;

public class InputConditonValConstsHandler
extends AbstractInputConstsHandler<IDataEntityProperty> {
    public static final Log log = LogFactory.getLog(InputConditonValConstsHandler.class);
    public static final String CALL_BACK_PREFIX = "conditionValCB";

    @Override
    public String getPrefixKey() {
        return CALL_BACK_PREFIX;
    }

    @Override
    protected FormShowParameter buildFormShowParam(IDataEntityProperty prop, String srcValue) {
        if (StringUtils.isBlank((CharSequence)srcValue)) {
            srcValue = SerializationUtils.toJsonString((Object)new CRValByConditions());
        } else {
            try {
                SerializationUtils.fromJsonString((String)srcValue, CRValByConditions.class);
            }
            catch (Exception e) {
                log.info("\u8f6c\u6362\u9519\u8bef\uff1a" + srcValue);
                log.info("\u9519\u8bef\u4fe1\u606f\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                srcValue = SerializationUtils.toJsonString((Object)new CRValByConditions());
            }
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ism_valbycondition");
        showParameter.getCustomParams().put("crvalbyconditions", srcValue);
        showParameter.getCustomParams().put("entitynumber", "ism_billmapcfg");
        if (prop instanceof BasedataProp) {
            showParameter.getCustomParams().put("baseentityid", ((BasedataProp)prop).getBaseEntityId());
        } else if (prop instanceof ComboProp) {
            List comboItems = ((ComboProp)prop).getComboItems();
            ArrayList combitems = new ArrayList(comboItems.size());
            for (ValueMapItem item : comboItems) {
                HashMap<String, String> values = new HashMap<String, String>(3);
                values.put("ImageKey", item.getImageKey());
                values.put("Name", item.getName().getLocaleValue());
                values.put("Value", item.getValue());
                combitems.add(values);
            }
            showParameter.getCustomParams().put("comboProp", combitems);
        }
        showParameter.getCustomParams().put("functiontypes", InputConditonValConstsHandler.getSupportFuncitonXmlStr());
        showParameter.setAppId("057C+RJ/1S7U");
        return showParameter;
    }

    private static String getSupportFuncitonXmlStr() {
        FunctionTypes newFunctions = new FunctionTypes();
        FunctionTypes funcTypes = ConvertFuncLoader.loadBizCloudFuncTypes();
        List functionGroups = funcTypes.getFunctionGroups();
        for (FunctionGroup functionGroup : functionGroups) {
            if (!"BOTP".equals(functionGroup.getId())) continue;
            newFunctions.getFunctionGroups().add(functionGroup);
        }
        List functionTypes = funcTypes.getFunctionTypes();
        for (FunctionType functionType : functionTypes) {
            if (!"GetSrcEntityNumber".equals(functionType.getId())) continue;
            newFunctions.getFunctionTypes().add(functionType);
        }
        return FunctionTypes.serializeToXML((FunctionTypes)newFunctions);
    }

    @Override
    protected InputConstsResult buildResultInfo(ClosedCallBackEvent e) {
        String returnData = (String)e.getReturnData();
        if (returnData == null) {
            return null;
        }
        CRValByConditions valByConditions = (CRValByConditions)SerializationUtils.fromJsonString((String)returnData, CRValByConditions.class);
        return new InputConstsResult(valByConditions.getDescription(), returnData);
    }
}

