/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper.inputconsts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.scmc.ism.business.helper.inputconsts.AbstractInputConstsHandler;
import kd.scmc.ism.common.model.args.InputConstsResult;
import kd.scmc.ism.common.utils.CommonUtils;

public class InputMultiComboConstsHandler
extends AbstractInputConstsHandler<ComboProp> {
    public static final String CALL_BACK_PREFIX = "multiSelectComboCB";

    @Override
    public String getPrefixKey() {
        return CALL_BACK_PREFIX;
    }

    @Override
    protected FormShowParameter buildFormShowParam(ComboProp prop, String srcValue) {
        List comboItems = prop.getComboItems();
        ArrayList combitems = new ArrayList(comboItems.size());
        for (ValueMapItem item : comboItems) {
            HashMap<String, String> values = new HashMap<String, String>(3);
            values.put("ImageKey", item.getImageKey());
            values.put("Name", item.getName().getLocaleValue());
            values.put("Value", item.getValue());
            combitems.add(values);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ism_comboitemsmulselect");
        showParameter.getCustomParams().put("comboProp", combitems);
        showParameter.getCustomParams().put("selectCombo", srcValue);
        return showParameter;
    }

    @Override
    protected InputConstsResult buildResultInfo(ClosedCallBackEvent e) {
        String returnData = (String)e.getReturnData();
        if (StringUtils.isEmpty((CharSequence)returnData)) {
            return null;
        }
        List formulas = SerializationUtils.fromJsonStringToList((String)returnData, CRFormula.class);
        if (CommonUtils.collectionIsEmpty(formulas)) {
            return new InputConstsResult("", "");
        }
        ArrayList<String> keys = new ArrayList<String>(formulas.size());
        ArrayList<String> names = new ArrayList<String>(formulas.size());
        for (CRFormula crFormula : formulas) {
            keys.add(crFormula.getExpression());
            names.add(crFormula.getExprTran());
        }
        String f7namesText = ((Object)names).toString();
        int namesStrs = f7namesText.length();
        String appends = "";
        if (namesStrs > 1997) {
            namesStrs = 1997;
            appends = "...";
        }
        return new InputConstsResult(f7namesText.substring(1, namesStrs - 1) + appends, SerializationUtils.toJsonString(keys));
    }
}

