/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper.inputconsts;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.list.ListShowParameter;
import kd.scmc.ism.business.helper.inputconsts.AbstractInputConstsHandler;
import kd.scmc.ism.common.model.args.InputConstsResult;
import kd.scmc.ism.common.utils.CommonUtils;
import org.apache.commons.lang.StringUtils;

public class InputMultiF7ConstsHandler
extends AbstractInputConstsHandler<BasedataProp> {
    public static final String CALL_BACK_PREFIX = "multiSelectF7CB";

    @Override
    public String getPrefixKey() {
        return CALL_BACK_PREFIX;
    }

    @Override
    protected FormShowParameter buildFormShowParam(BasedataProp prop, String srcValue) {
        Object[] pkIds = null;
        if (StringUtils.isNotEmpty((String)srcValue)) {
            List list = SerializationUtils.fromJsonStringToList((String)srcValue, Object.class);
            pkIds = list.toArray();
        }
        ListShowParameter basedataF7Param = ShowFormHelper.createShowListForm((String)prop.getBaseEntityId(), (boolean)true);
        if (pkIds != null) {
            basedataF7Param.setSelectedRows(pkIds);
        }
        return basedataF7Param;
    }

    @Override
    protected InputConstsResult buildResultInfo(ClosedCallBackEvent e) {
        ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
        if (CommonUtils.collectionIsEmpty(rows)) {
            return null;
        }
        ArrayList<Object> pkValues = new ArrayList<Object>(rows.size());
        ArrayList<String> names = new ArrayList<String>(rows.size());
        for (ListSelectedRow row : rows) {
            pkValues.add(row.getPrimaryKeyValue());
            names.add(row.getName());
        }
        String f7namesText = ((Object)names).toString();
        int namesStrs = f7namesText.length();
        String appends = "";
        if (namesStrs > 1997) {
            namesStrs = 1997;
            appends = "...";
        }
        return new InputConstsResult(f7namesText.substring(1, namesStrs - 1) + appends, SerializationUtils.toJsonString(pkValues));
    }
}

