/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper.recalprice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.ism.business.helper.CurrencyHelper;

public class OrderBillAmountReCalHelper {
    private static String CURRENCY_DT = "bd_currency";
    private static String EXRATETABLE_DT = "bd_exratetable";
    private static String BASECURRRENCY = "baseCurrencyID";
    private static String EXRATETABLE = "exchangeRateTableID";

    public static void orderBillAmountReCal(DynamicObject bill) {
        BigDecimal exChangeRate = bill.getBigDecimal("exchangerate");
        DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
        DynamicObject currency = bill.getDynamicObject("currency");
        DynamicObject exRateTable = bill.getDynamicObject("exratetable");
        DynamicObject org = bill.getDynamicObject("org");
        if (org != null) {
            Long orgId = (Long)org.getPkValue();
            if (currency == null) {
                currency = OrderBillAmountReCalHelper.getCurrency(orgId);
                bill.set("currency", (Object)currency);
            }
            if (exRateTable == null) {
                exRateTable = OrderBillAmountReCalHelper.getExRateTable(orgId);
                bill.set("exratetable", (Object)exRateTable);
            }
        }
        if (exChangeRate == null || exChangeRate.compareTo(BigDecimal.ZERO) == 0) {
            Date bizTime = bill.getDate("exratedate");
            if (currency != null && settleCurrency != null && exRateTable != null && bizTime != null) {
                Long curId = (Long)currency.getPkValue();
                Long settleCurId = (Long)settleCurrency.getPkValue();
                Long exRateTableId = (Long)exRateTable.getPkValue();
                exChangeRate = OrderBillAmountReCalHelper.getExChangeRate(settleCurId, curId, exRateTableId, bizTime);
                bill.set("exchangerate", (Object)exChangeRate);
            }
        }
        OrderBillAmountReCalHelper.calculateAmount4WholeBill(bill);
    }

    public static void calculateAmount4WholeBill(DynamicObject bill) {
        BigDecimal totalAllAmount = BigDecimal.ZERO;
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal curTotalAllAmount = BigDecimal.ZERO;
        BigDecimal curTotalAmount = BigDecimal.ZERO;
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        for (int i = 0; i < entrys.size(); ++i) {
            AmountResult amountResult = new AmountResult(bill, i).invoke();
            if (amountResult.is()) continue;
            DynamicObject entryInfo = amountResult.getEntryInfo();
            BigDecimal amountAndTax = amountResult.getAmountAndTax();
            BigDecimal taxAmout = amountResult.getTaxAmout();
            BigDecimal amount = amountResult.getAmount();
            BigDecimal curAmountAndTax = amountResult.getCurAmountAndTax();
            BigDecimal curAmount = amountResult.getCurAmount();
            BigDecimal curTaxAmount = amountResult.getCurTaxAmount();
            entryInfo.set("amountandtax", (Object)amountAndTax);
            entryInfo.set("amount", (Object)amount);
            entryInfo.set("taxamount", (Object)taxAmout);
            entryInfo.set("curamountandtax", (Object)curAmountAndTax);
            entryInfo.set("curamount", (Object)curAmount);
            entryInfo.set("curtaxamount", (Object)curTaxAmount);
            totalAllAmount = totalAllAmount.add(amountAndTax);
            totalAmount = totalAmount.add(amount);
            totalTaxAmount = totalTaxAmount.add(taxAmout);
            curTotalAllAmount = curTotalAllAmount.add(curAmountAndTax);
            curTotalAmount = curTotalAmount.add(curAmount);
        }
        bill.set("totalallamount", (Object)totalAllAmount);
        bill.set("totalamount", (Object)totalAmount);
        bill.set("totaltaxamount", (Object)totalTaxAmount);
        if ("sm_salorder".equals(bill.getDynamicObjectType().getName())) {
            bill.set("curtotalallamount", (Object)curTotalAllAmount);
            bill.set("curtotalamount", (Object)curTotalAmount);
        }
    }

    public static DynamicObject getCurrency(Long orgId) {
        Long currencyId;
        Map<String, Long> map;
        if (orgId != 0L && (map = OrderBillAmountReCalHelper.getCurrencyAndExRateTable(orgId)) != null && (currencyId = map.get(BASECURRRENCY)) != null && currencyId != 0L) {
            return BusinessDataServiceHelper.loadSingle((Object)currencyId, (String)CURRENCY_DT);
        }
        return null;
    }

    public static DynamicObject getExRateTable(Long orgId) {
        Map<String, Long> map;
        if (orgId != null && (map = OrderBillAmountReCalHelper.getCurrencyAndExRateTable(orgId)) != null) {
            return BusinessDataServiceHelper.loadSingle((Object)map.get(EXRATETABLE), (String)EXRATETABLE_DT);
        }
        return null;
    }

    public static Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        Map map;
        Map mapOrg;
        if (orgId != null && (mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)) != null && mapOrg.get("id") != null && (map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")))) != null && map.size() != 0) {
            return map;
        }
        return null;
    }

    public static BigDecimal getExChangeRate(Long srcCurId, Long targCurId, Long exRateTableId, Date date) {
        BigDecimal exChangeRate = BigDecimal.ZERO;
        exChangeRate = srcCurId.equals(targCurId) ? BigDecimal.ONE : BaseDataServiceHelper.getExchangeRate((Long)exRateTableId, (Long)srcCurId, (Long)targCurId, (Date)date);
        return exChangeRate;
    }

    private static class AmountResult {
        private boolean myResult;
        private DynamicObject bill;
        private int rowIndex;
        private DynamicObject entryInfo;
        private BigDecimal amountAndTax;
        private BigDecimal taxAmout;
        private BigDecimal amount;
        private BigDecimal curAmountAndTax;
        private BigDecimal curAmount;
        private BigDecimal curTaxAmount;

        public AmountResult(DynamicObject bill, int rowIndex) {
            this.bill = bill;
            this.rowIndex = rowIndex;
        }

        boolean is() {
            return this.myResult;
        }

        public DynamicObject getEntryInfo() {
            return this.entryInfo;
        }

        public BigDecimal getAmountAndTax() {
            return this.amountAndTax;
        }

        public BigDecimal getTaxAmout() {
            return this.taxAmout;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public BigDecimal getCurAmountAndTax() {
            return this.curAmountAndTax;
        }

        public BigDecimal getCurAmount() {
            return this.curAmount;
        }

        public BigDecimal getCurTaxAmount() {
            return this.curTaxAmount;
        }

        public AmountResult invoke() {
            DynamicObjectCollection colls = this.bill.getDynamicObjectCollection("billentry");
            if (colls.size() == 0) {
                this.myResult = true;
                return this;
            }
            this.entryInfo = (DynamicObject)colls.get(this.rowIndex);
            BigDecimal price = this.entryInfo.getBigDecimal("price");
            BigDecimal priceAndTax = this.entryInfo.getBigDecimal("priceandtax");
            BigDecimal qty = this.entryInfo.getBigDecimal("qty");
            BigDecimal taxRate = this.entryInfo.getBigDecimal("taxrate");
            taxRate = taxRate.divide(new BigDecimal(100));
            Boolean isTax = this.bill.getBoolean("istax");
            BigDecimal discountAmount = BigDecimal.ZERO;
            int precision = 10;
            DynamicObject currency = this.bill.getDynamicObject("settlecurrency");
            if (currency != null) {
                precision = currency.getInt("amtprecision");
            }
            String discountType = this.entryInfo.getString("discounttype");
            BigDecimal discountRate = this.entryInfo.getBigDecimal("discountrate");
            if (isTax.booleanValue()) {
                price = priceAndTax.divide(BigDecimal.ONE.add(taxRate), 10, 4);
                if ("A".equals(discountType)) {
                    if (discountRate.compareTo(new BigDecimal("100")) > 0) {
                        discountRate = new BigDecimal("100");
                    }
                    discountRate = discountRate.divide(new BigDecimal(100));
                    discountAmount = qty.multiply(priceAndTax).multiply(discountRate);
                    discountAmount = discountAmount.setScale(precision, RoundingMode.HALF_UP);
                    this.amountAndTax = qty.multiply(priceAndTax).subtract(discountAmount);
                    this.amountAndTax = this.amountAndTax.setScale(precision, RoundingMode.HALF_UP);
                } else if ("B".equals(discountType)) {
                    if (discountRate.compareTo(priceAndTax) > 0) {
                        discountRate = priceAndTax;
                    }
                    discountAmount = qty.multiply(discountRate);
                    discountAmount = discountAmount.setScale(precision, RoundingMode.HALF_UP);
                    this.amountAndTax = qty.multiply(priceAndTax).subtract(discountAmount);
                    this.amountAndTax = this.amountAndTax.setScale(precision, RoundingMode.HALF_UP);
                } else {
                    this.amountAndTax = qty.multiply(priceAndTax);
                    this.amountAndTax = this.amountAndTax.setScale(precision, RoundingMode.HALF_UP);
                }
                this.taxAmout = this.amountAndTax.divide(BigDecimal.ONE.add(taxRate), 10, 4).multiply(taxRate);
                this.taxAmout = this.taxAmout.setScale(precision, RoundingMode.HALF_UP);
                this.amount = this.amountAndTax.subtract(this.taxAmout);
                this.amount = this.amount.setScale(precision, RoundingMode.HALF_UP);
                this.entryInfo.set("price", (Object)price);
            } else {
                priceAndTax = price.multiply(BigDecimal.ONE.add(taxRate));
                if ("A".equals(discountType)) {
                    if (discountRate.compareTo(new BigDecimal("100")) > 0) {
                        discountRate = new BigDecimal("100");
                    }
                    discountRate = discountRate.divide(new BigDecimal(100));
                    discountAmount = qty.multiply(priceAndTax).multiply(discountRate);
                    discountAmount = discountAmount.setScale(precision, RoundingMode.HALF_UP);
                    this.amount = qty.multiply(price).multiply(BigDecimal.ONE.subtract(discountRate));
                    this.amount = this.amount.setScale(precision, RoundingMode.HALF_UP);
                } else if ("B".equals(discountType)) {
                    if (discountRate.compareTo(price) > 0) {
                        discountRate = price;
                    }
                    discountAmount = qty.multiply(discountRate).multiply(BigDecimal.ONE.add(taxRate));
                    discountAmount = discountAmount.setScale(precision, RoundingMode.HALF_UP);
                    this.amount = qty.multiply(price.subtract(discountRate));
                    this.amount = this.amount.setScale(precision, RoundingMode.HALF_UP);
                } else {
                    this.amount = qty.multiply(price);
                    this.amount = this.amount.setScale(precision, RoundingMode.HALF_UP);
                }
                this.taxAmout = this.amount.multiply(taxRate);
                this.taxAmout = this.taxAmout.setScale(precision, RoundingMode.HALF_UP);
                this.amountAndTax = this.amount.add(this.taxAmout);
                this.amountAndTax = this.amountAndTax.setScale(precision, RoundingMode.HALF_UP);
                this.entryInfo.set("priceandtax", (Object)priceAndTax);
            }
            DynamicObject currencyObj = this.bill.getDynamicObject("currency");
            int currencyPrecision = 10;
            if (currencyObj != null) {
                currencyPrecision = currencyObj.getInt("amtprecision");
            }
            BigDecimal exChangeRate = this.bill.getBigDecimal("exchangerate");
            String exhangeType = this.bill.getString("exchangetype");
            this.curTaxAmount = CurrencyHelper.exrateExchange(this.taxAmout, exhangeType, exChangeRate, currencyPrecision);
            if (isTax.booleanValue()) {
                this.curAmountAndTax = CurrencyHelper.exrateExchange(this.amountAndTax, exhangeType, exChangeRate, currencyPrecision);
                this.curAmount = this.curAmountAndTax.subtract(this.curTaxAmount);
            } else {
                this.curAmount = CurrencyHelper.exrateExchange(this.amount, exhangeType, exChangeRate, currencyPrecision);
                this.curAmountAndTax = this.curAmount.add(this.curTaxAmount);
            }
            this.entryInfo.set("discountamount", (Object)discountAmount);
            this.myResult = false;
            return this;
        }
    }
}

