/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper.recalprice.arap;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.ism.business.helper.recalprice.arap.AbstractPriceCalculator;
import kd.scmc.ism.business.helper.recalprice.arap.PriceLocalCalculator;
import kd.scmc.ism.business.helper.recalprice.arap.TaxUnitPriceCalculator;
import kd.scmc.ism.business.helper.recalprice.arap.UnitPriceCalculator;
import kd.scmc.ism.lang.CommonLang;

public class ApBillAmountReCalHelper {
    public static void apBillAmountReCal(DynamicObject finAPBill) {
        DynamicObject org = finAPBill.getDynamicObject("org");
        DynamicObject payorg = finAPBill.getDynamicObject("payorg");
        if (!ObjectUtils.isEmpty((Object)payorg) && !payorg.getBoolean("fisbankroll")) {
            finAPBill.set("payorg", null);
        }
        if (ObjectUtils.isEmpty((Object)org)) {
            return;
        }
        QFilter qFilter = new QFilter("org", "=", org.getPkValue());
        DynamicObject init = BusinessDataServiceHelper.loadSingle((String)"ap_init", (String)ApBillAmountReCalHelper.getInitSelectors(), (QFilter[])new QFilter[]{qFilter});
        if (init == null || init.getDate("startdate") == null) {
            ErrorCode ORGNAME_NOT_SET = new ErrorCode("ARAPORGNAME_NOT_FINISHINIT", CommonLang.orgNotInitCanNotCreateBill());
            throw new KDBizException(ORGNAME_NOT_SET, new Object[]{org.getLocaleString("name").getLocaleValue()});
        }
        DynamicObject bascurrency = init.getDynamicObject("standardcurrency");
        finAPBill.set("basecurrency", (Object)bascurrency);
        DynamicObject exeatetable = init.getDynamicObject("exratetable");
        finAPBill.set("exratetable", (Object)exeatetable);
        finAPBill.set("exratedate", (Object)new Date());
        DynamicObject currency = finAPBill.getDynamicObject("currency");
        if (bascurrency != null && currency != null && exeatetable != null) {
            BigDecimal exchangeRate = ApBillAmountReCalHelper.getExchangeRate(exeatetable.getLong("id"), currency.getLong("id"), bascurrency.getLong("id"), new Date());
            finAPBill.set("exchangerate", (Object)exchangeRate);
        }
        DynamicObject bascur = finAPBill.getDynamicObject("basecurrency");
        int baseprecision = bascur.getInt("amtprecision");
        finAPBill.set("duedate", (Object)new Date());
        DynamicObjectCollection entries = finAPBill.getDynamicObjectCollection("detailentry");
        boolean includeTax = finAPBill.getBoolean("isincludetax");
        BigDecimal exchangeRate = finAPBill.getBigDecimal("exchangerate");
        BigDecimal payableAmount = BigDecimal.ZERO;
        BigDecimal amountbase = BigDecimal.ZERO;
        BigDecimal pricetaxtotalbase = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal unVerifyAmount = BigDecimal.ZERO;
        BigDecimal unSettleAmount = BigDecimal.ZERO;
        for (DynamicObject entry : entries) {
            PriceLocalCalculator localCalculator = null;
            AbstractPriceCalculator calculator = null;
            BigDecimal qty = entry.getBigDecimal("quantity");
            BigDecimal taxRate = entry.getBigDecimal("taxrate");
            String discountMode = entry.getString("discountmode");
            BigDecimal discountRate = entry.getBigDecimal("discountrate");
            if (includeTax) {
                BigDecimal taxUnitPrice = entry.getBigDecimal("pricetax");
                calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, baseprecision);
            } else {
                BigDecimal unitPrice = entry.getBigDecimal("price");
                calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, baseprecision);
            }
            localCalculator = new PriceLocalCalculator(calculator, exchangeRate, baseprecision);
            localCalculator.calculate();
            BigDecimal e_amountbase = localCalculator.getAmountlocal();
            BigDecimal e_pricetaxtotalbase = localCalculator.getPricetaxtotallocal();
            BigDecimal e_pricetaxtotal = localCalculator.getPricetaxtotal();
            BigDecimal e_amount = localCalculator.getAmount();
            BigDecimal e_tax = localCalculator.getTax();
            amountbase = amountbase.add(e_amountbase);
            pricetaxtotalbase = pricetaxtotalbase.add(e_pricetaxtotalbase);
            payableAmount = payableAmount.add(e_pricetaxtotal);
            amount = amount.add(e_amount);
            tax = tax.add(e_tax);
            unVerifyAmount = unVerifyAmount.add(e_pricetaxtotal);
            unSettleAmount = unSettleAmount.add(e_amount);
            entry.set("actprice", (Object)localCalculator.getActunitprice());
            entry.set("actpricetax", (Object)localCalculator.getActtaxunitprice());
            entry.set("discountamount", (Object)localCalculator.getDiscountamount());
            entry.set("discountlocalamt", (Object)localCalculator.getDiscountamountlocal());
            entry.set("e_amount", (Object)e_amount);
            entry.set("e_amountbase", (Object)e_amountbase);
            entry.set("e_tax", (Object)e_tax);
            entry.set("e_pricetaxtotal", (Object)e_pricetaxtotal);
            entry.set("unlockamt", (Object)localCalculator.getPricetaxtotal());
            entry.set("unsettleamt", (Object)localCalculator.getPricetaxtotal());
            entry.set("e_unverifyamount", (Object)e_amount);
            entry.set("e_pricetaxtotalbase", (Object)e_pricetaxtotalbase);
            entry.set("unsettleamtbase", (Object)e_pricetaxtotalbase);
            BigDecimal quantity = entry.getBigDecimal("quantity");
            if (quantity == null) {
                quantity = BigDecimal.ZERO;
            }
            BigDecimal covertRate = entry.getBigDecimal("e_unitconvertrate");
            DynamicObject material = entry.getDynamicObject("material");
            DynamicObject measureUnit = entry.getDynamicObject("measureunit");
            if (!ObjectUtils.isEmpty((Object)material) && covertRate.compareTo(BigDecimal.ZERO) == 0) {
                DynamicObject baseUnit = material.getDynamicObject("baseunit");
                if (baseUnit != null) {
                    entry.set("e_baseunit", (Object)baseUnit);
                    if (measureUnit != null) {
                        covertRate = ApBillAmountReCalHelper.getUnitRateConv(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"));
                        if (covertRate != null) {
                            entry.set("e_unitconvertrate", (Object)covertRate);
                            entry.set("e_baseunitqty", (Object)quantity.multiply(covertRate));
                        } else {
                            entry.set("e_unitconvertrate", (Object)1);
                            entry.set("e_baseunitqty", (Object)quantity);
                        }
                    }
                }
            } else {
                entry.set("e_baseunitqty", (Object)covertRate.multiply(quantity));
            }
            entry.set("unverifyquantity", (Object)quantity);
        }
        finAPBill.set("pricetaxtotal", (Object)payableAmount);
        finAPBill.set("pricetaxtotalbase", (Object)pricetaxtotalbase);
        finAPBill.set("amount", (Object)amount);
        finAPBill.set("amountbase", (Object)amountbase);
        finAPBill.set("tax", (Object)tax);
        finAPBill.set("unverifyamount", (Object)unVerifyAmount);
        finAPBill.set("unsettleamount", (Object)unSettleAmount);
        finAPBill.set("unsettleamountbase", (Object)pricetaxtotalbase);
        EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)"ap_finapbill").findProperty("planentity");
        DynamicObjectType dt = prop.getDynamicCollectionItemPropertyType();
        DynamicObject planEntry = new DynamicObject(dt);
        planEntry.set("planduedate", (Object)new Date());
        planEntry.set("planpricetax", (Object)payableAmount);
        if (!ObjectUtils.isEmpty((Object)finAPBill.getDynamicObject("settlementtype"))) {
            planEntry.set("plansettletype", (Object)finAPBill.getDynamicObject("settlementtype"));
        }
        planEntry.set("planpricetaxloc", (Object)pricetaxtotalbase);
        planEntry.set("unplansettleamt", (Object)payableAmount);
        planEntry.set("unplansettlelocamt", (Object)pricetaxtotalbase);
        planEntry.set("unplanlockamt", (Object)payableAmount);
        DynamicObject asstact = finAPBill.getDynamicObject("asstact");
        if (asstact != null) {
            String asstactType = asstact.getDataEntityType().getName();
            if (!"bd_supplier".equals(asstactType)) {
                finAPBill.set("paymentcurrency", (Object)finAPBill.getDynamicObject("currency"));
            } else {
                Object asstactPk = asstact.getPkValue();
                DynamicObject asstactFieldValue = BusinessDataServiceHelper.loadSingle((String)"bd_supplier", (String)"paymentcurrency, entry_bank.bankaccount, entry_bank.bank, entry_bank.isdefault_bank", (QFilter[])new QFilter[]{new QFilter("id", "=", asstactPk)});
                DynamicObjectCollection entryBanks = asstactFieldValue.getDynamicObjectCollection("entry_bank");
                String acctBank = null;
                DynamicObject bank = null;
                if (entryBanks.size() == 1) {
                    asstact = (DynamicObject)entryBanks.get(0);
                    acctBank = asstact.getString("bankaccount");
                    bank = asstact.getDynamicObject("bank");
                } else {
                    for (int i = 0; i < entryBanks.size(); ++i) {
                        asstact = (DynamicObject)entryBanks.get(i);
                        if (asstact.getBoolean("isdefault_bank")) {
                            acctBank = asstact.getString("bankaccount");
                            bank = asstact.getDynamicObject("bank");
                            break;
                        }
                        if (i != 0) continue;
                        acctBank = asstact.getString("bankaccount");
                        bank = asstact.getDynamicObject("bank");
                    }
                }
                finAPBill.set("payeebanknum", (Object)acctBank);
                finAPBill.set("bebank", (Object)bank);
                DynamicObject paymentCurrency = asstactFieldValue.getDynamicObject("paymentcurrency");
                if (ObjectUtils.isEmpty((Object)paymentCurrency)) {
                    finAPBill.set("paymentcurrency", (Object)finAPBill.getDynamicObject("currency"));
                } else {
                    finAPBill.set("paymentcurrency", (Object)paymentCurrency);
                }
            }
        }
    }

    public static BigDecimal getExchangeRate(Long exratetableId, Long srcCurrencyId, Long destCurrencyId, Date exrateDate) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (exrateDate == null) {
            exrateDate = new Date();
        }
        if (srcCurrencyId == null || srcCurrencyId == 0L || destCurrencyId == null || destCurrencyId == 0L || srcCurrencyId.equals(destCurrencyId)) {
            return exchangeRate;
        }
        exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exratetableId, (Long)srcCurrencyId, (Long)destCurrencyId, (Date)exrateDate);
        return exchangeRate;
    }

    private static String getInitSelectors() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("id");
        selectors.add("standardcurrency");
        selectors.add("exratetable");
        selectors.add("isfinishinit");
        selectors.add("startdate");
        return String.join((CharSequence)",", selectors);
    }

    private static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId) {
        BigDecimal unitRate = null;
        DynamicObject muConv1 = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
        if (!ObjectUtils.isEmpty((Object)muConv1) && muConv1.getInt("numerator") != 0) {
            unitRate = muConv1.getBigDecimal("numerator").divide(muConv1.getBigDecimal("denominator"), 10, RoundingMode.HALF_UP);
        } else {
            DynamicObject muConv2 = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)desUnitId, (Long)srcUnitId);
            if (!ObjectUtils.isEmpty((Object)muConv2) && muConv2.getInt("numerator") != 0) {
                unitRate = muConv2.getBigDecimal("denominator").divide(muConv2.getBigDecimal("numerator"), 10, RoundingMode.HALF_UP);
            }
        }
        return unitRate;
    }
}

