/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper.recalprice.arap;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.scmc.ism.business.helper.recalprice.arap.AbstractPriceCalculator;

public class PriceTaxTotalCalculator
extends AbstractPriceCalculator {
    public PriceTaxTotalCalculator(BigDecimal quantity, BigDecimal pricetaxtotal, BigDecimal taxrate, String discountmode, BigDecimal discountrate, int currencyPrecision) {
        this.isTax = false;
        this.quantity = quantity.setScale(10, RoundingMode.HALF_UP);
        this.pricetaxtotal = pricetaxtotal.setScale(currencyPrecision, RoundingMode.HALF_UP);
        taxrate = taxrate.divide(ONE_HUNDRED);
        this.taxrate = taxrate.setScale(10, RoundingMode.HALF_UP);
        this.discountmode = discountmode;
        this.discountrate = discountrate.setScale(10, RoundingMode.HALF_UP);
        this.currencyPrecision = currencyPrecision;
    }

    @Override
    public void calculate() {
        if (BigDecimal.ZERO.compareTo(this.quantity) == 0) {
            return;
        }
        BigDecimal taxRate = this.taxrate;
        this.acttaxunitprice = this.pricetaxtotal.divide(this.quantity, 10, RoundingMode.HALF_UP);
        this.actunitprice = this.acttaxunitprice.divide(ONE.add(taxRate), 10, RoundingMode.HALF_UP);
        if ("PERCENT".equals(this.discountmode)) {
            BigDecimal discountRate = this.discountrate.divide(ONE_HUNDRED);
            if (discountRate.compareTo(ONE) != 0) {
                this.unitprice = this.actunitprice.divide(ONE.subtract(discountRate), 10, RoundingMode.HALF_UP);
            }
            this.taxunitprice = this.unitprice.multiply(ONE.add(taxRate)).setScale(10, RoundingMode.HALF_UP);
            this.discountamount = discountRate.multiply(this.quantity).multiply(this.taxunitprice).setScale(this.currencyPrecision, RoundingMode.HALF_UP);
        } else if ("PERUNIT".equals(this.discountmode)) {
            this.unitprice = this.actunitprice.add(this.discountrate).setScale(10, RoundingMode.HALF_UP);
            this.taxunitprice = this.unitprice.multiply(ONE.add(taxRate)).setScale(10, RoundingMode.HALF_UP);
            this.discountamount = this.discountrate.multiply(ONE.add(taxRate)).multiply(this.quantity).setScale(this.currencyPrecision, RoundingMode.HALF_UP);
        } else {
            this.unitprice = this.actunitprice;
            this.taxunitprice = this.acttaxunitprice;
        }
        this.tax = this.actunitprice.multiply(this.quantity).multiply(this.taxrate).setScale(this.currencyPrecision, RoundingMode.HALF_UP);
        this.amount = this.pricetaxtotal.subtract(this.tax);
    }
}

