/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper.recalprice.arap;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.scmc.ism.business.helper.recalprice.arap.AbstractPriceCalculator;

public class UnitPriceCalculator
extends AbstractPriceCalculator {
    public UnitPriceCalculator(BigDecimal quantity, BigDecimal unitprice, BigDecimal taxrate, String discountmode, BigDecimal discountrate, int currencyPrecision) {
        this.isTax = false;
        this.quantity = quantity.setScale(10, RoundingMode.HALF_UP);
        this.unitprice = unitprice.setScale(10, RoundingMode.HALF_UP);
        taxrate = taxrate.divide(ONE_HUNDRED);
        this.taxrate = taxrate.setScale(10, RoundingMode.HALF_UP);
        this.discountmode = discountmode;
        this.discountrate = discountrate.setScale(10, RoundingMode.HALF_UP);
        this.currencyPrecision = currencyPrecision;
    }

    @Override
    public void calculate() {
        this.taxunitprice = this.unitprice.multiply(ONE.add(this.taxrate)).setScale(10, RoundingMode.HALF_UP);
        if ("PERCENT".equals(this.discountmode)) {
            this.actunitprice = this.unitprice.multiply(ONE.subtract(this.discountrate.divide(ONE_HUNDRED))).setScale(10, RoundingMode.HALF_UP);
            this.discountamount = this.taxunitprice.multiply(this.quantity).multiply(this.discountrate.divide(ONE_HUNDRED)).setScale(this.currencyPrecision, RoundingMode.HALF_UP);
        } else if ("PERUNIT".equals(this.discountmode)) {
            this.actunitprice = this.unitprice.subtract(this.discountrate).setScale(10, RoundingMode.HALF_UP);
            this.discountamount = this.discountrate.multiply(this.quantity).multiply(ONE.add(this.taxrate)).setScale(this.currencyPrecision, RoundingMode.HALF_UP);
        } else {
            this.actunitprice = this.unitprice;
        }
        this.tax = this.actunitprice.multiply(this.quantity).multiply(this.taxrate).setScale(this.currencyPrecision, RoundingMode.HALF_UP);
        this.amount = this.actunitprice.multiply(this.quantity).setScale(this.currencyPrecision, RoundingMode.HALF_UP);
        this.pricetaxtotal = this.amount.add(this.tax);
        this.acttaxunitprice = this.pricetaxtotal.divide(this.quantity, this.currencyPrecision, RoundingMode.HALF_UP);
    }
}

